/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.RotatableDecoration3D;
import org.eclipse.draw3d.ShapeFigure3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.util.Draw3DCache;

public abstract class ShapeDecoration
extends ShapeFigure3D
implements RotatableDecoration3D {
    private Vector3fImpl m_lastReference = new Vector3fImpl(0.0f, 0.0f, 0.0f);

    public void setReferencePoint(Point i_p) {
        throw new UnsupportedOperationException("reference point must be 3D");
    }

    public void setReferencePoint3D(IVector3f i_reference) {
        if (i_reference == null) {
            if (this.m_lastReference.x == 0.0f && this.m_lastReference.y == 0.0f && this.m_lastReference.z == 0.0f) {
                return;
            }
            this.getPosition3D().setRotation3D((IVector3f)this.m_lastReference);
        } else {
            if (i_reference.equals((IVector3f)this.m_lastReference)) {
                return;
            }
            Vector3f tmp = Draw3DCache.getVector3f();
            try {
                tmp.set(this.getPosition3D().getLocation3D());
                Math3D.sub((IVector3f)i_reference, (IVector3f)tmp, (Vector3f)tmp);
                Math3D.normalise((IVector3f)tmp, (Vector3f)tmp);
                Math3D.eulerAngles((IVector3f)IVector3f.Z_AXIS_NEG, (IVector3f)tmp, (Vector3f)tmp);
                this.getPosition3D().setRotation3D((IVector3f)tmp);
                this.m_lastReference.set((IVector3f)tmp);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
        }
    }
}

