/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.widgets.LanguageConfigurationInfoWidget;

public class LanguageConfigurationPreferencesWidget
extends LanguageConfigurationInfoWidget {
    private Button toggleOnEnterButton;
    private Button toggleBracketAutoClosingButton;
    private Button toggleMatchingPairsButton;
    private ILanguageConfigurationDefinition definition;
    private ILanguageConfigurationRegistryManager manager;

    public LanguageConfigurationPreferencesWidget(Composite parent, int style) {
        super(parent, style);
    }

    public void refresh(ILanguageConfigurationDefinition definition, ILanguageConfigurationRegistryManager manager) {
        super.refresh(definition == null ? null : definition.getLanguageConfiguration());
        if (definition == null) {
            this.toggleOnEnterButton.setEnabled(false);
            this.toggleOnEnterButton.setSelection(false);
            this.toggleBracketAutoClosingButton.setEnabled(false);
            this.toggleBracketAutoClosingButton.setSelection(false);
            this.toggleMatchingPairsButton.setEnabled(false);
            this.toggleMatchingPairsButton.setSelection(false);
            return;
        }
        this.toggleOnEnterButton.setSelection(definition.isOnEnterEnabled().booleanValue());
        this.toggleOnEnterButton.setEnabled(true);
        this.toggleBracketAutoClosingButton.setSelection(definition.isBracketAutoClosingEnabled().booleanValue());
        this.toggleBracketAutoClosingButton.setEnabled(true);
        this.toggleMatchingPairsButton.setSelection(definition.isMatchingPairsEnabled().booleanValue());
        this.toggleMatchingPairsButton.setEnabled(true);
        this.definition = definition;
        this.manager = manager;
    }

    @Override
    protected void createOnEnterRulesTab(TabFolder folder) {
        super.createOnEnterRulesTab(folder);
        Composite parent = (Composite)this.onEnterRulesTab.getControl();
        this.toggleOnEnterButton = new Button(parent, 32);
        this.toggleOnEnterButton.setText("Enable on enter actions");
        this.toggleOnEnterButton.setLayoutData((Object)new GridData(768));
        this.toggleOnEnterButton.setEnabled(false);
        this.toggleOnEnterButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.manager.unregisterLanguageConfigurationDefinition(this.definition);
            this.definition.setOnEnterEnabled(this.toggleOnEnterButton.getSelection());
            this.manager.registerLanguageConfigurationDefinition(this.definition);
        }));
    }

    public boolean getToggleOnEnter() {
        return this.toggleOnEnterButton.getSelection();
    }

    public void setToggleOnEnter(Boolean selection) {
        this.toggleOnEnterButton.setSelection(selection.booleanValue());
    }

    @Override
    protected void createAutoClosingPairsTab(TabFolder folder) {
        super.createAutoClosingPairsTab(folder);
        Composite parent = (Composite)this.autoClosingPairsTab.getControl();
        this.toggleBracketAutoClosingButton = new Button(parent, 32);
        this.toggleBracketAutoClosingButton.setText("Enable auto closing brackets");
        this.toggleBracketAutoClosingButton.setLayoutData((Object)new GridData(768));
        this.toggleBracketAutoClosingButton.setEnabled(false);
        this.toggleBracketAutoClosingButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.manager.unregisterLanguageConfigurationDefinition(this.definition);
            this.definition.setBracketAutoClosingEnabled(this.toggleBracketAutoClosingButton.getSelection());
            this.manager.registerLanguageConfigurationDefinition(this.definition);
        }));
    }

    public boolean getBracketAutoClosing() {
        return this.toggleBracketAutoClosingButton.getSelection();
    }

    public void setBracketAutoClosing(Boolean selection) {
        this.toggleBracketAutoClosingButton.setSelection(selection.booleanValue());
    }

    @Override
    protected void createSurroundingPairsTab(TabFolder folder) {
        super.createSurroundingPairsTab(folder);
        Composite parent = (Composite)this.surroundingPairsTab.getControl();
        this.toggleMatchingPairsButton = new Button(parent, 32);
        this.toggleMatchingPairsButton.setText("Enable matching brackets");
        this.toggleMatchingPairsButton.setLayoutData((Object)new GridData(768));
        this.toggleMatchingPairsButton.setEnabled(false);
        this.toggleMatchingPairsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.manager.unregisterLanguageConfigurationDefinition(this.definition);
            this.definition.setMatchingPairsEnabled(this.toggleMatchingPairsButton.getSelection());
            this.manager.registerLanguageConfigurationDefinition(this.definition);
        }));
    }

    public boolean getMatchingPairs() {
        return this.toggleMatchingPairsButton.getSelection();
    }

    public void setMatchingPairs(Boolean selection) {
        this.toggleMatchingPairsButton.setSelection(selection.booleanValue());
    }
}

