/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.oniguruma;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tm4e.core.internal.oniguruma.OnigRegExp;
import org.eclipse.tm4e.core.internal.oniguruma.OnigResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;

public class OnigSearcher {
    private final List<OnigRegExp> regExps = new ArrayList<OnigRegExp>();

    public OnigSearcher(String[] regexps) {
        int i = 0;
        while (i < regexps.length) {
            this.regExps.add(new OnigRegExp(regexps[i]));
            ++i;
        }
    }

    public OnigResult search(OnigString source, int charOffset) {
        int byteOffset = source.convertUtf16OffsetToUtf8(charOffset);
        int bestLocation = 0;
        OnigResult bestResult = null;
        int index = 0;
        for (OnigRegExp regExp : this.regExps) {
            OnigResult result = regExp.Search(source, byteOffset);
            if (result != null && result.count() > 0) {
                int location = result.LocationAt(0);
                if (bestResult == null || location < bestLocation) {
                    bestLocation = location;
                    bestResult = result;
                    bestResult.setIndex(index);
                }
                if (location == byteOffset) break;
            }
            ++index;
        }
        return bestResult;
    }
}

