/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.acceleo.aql.completion.proposals.AcceleoCompletionProposal;
import org.eclipse.acceleo.aql.completion.proposals.templates.AcceleoCodeTemplateCompletionProposal;
import org.eclipse.acceleo.aql.ls.common.AcceleoAstNodeToCompletionItemKind;
import org.eclipse.acceleo.aql.ls.common.AcceleoAstNodeToSymbolKind;
import org.eclipse.acceleo.aql.ls.common.AcceleoLanguageServerPositionUtils;
import org.eclipse.acceleo.aql.outline.AcceleoSymbol;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;

public final class AcceleoLanguageServerServicesUtils {
    private AcceleoLanguageServerServicesUtils() {
    }

    public static URI toUri(String stringUri) {
        try {
            return new URI(stringUri).normalize();
        }
        catch (URISyntaxException uriException) {
            throw new RuntimeException("Unexpected URI syntax: " + stringUri, uriException);
        }
    }

    public static List<CompletionItem> transform(List<AcceleoCompletionProposal> acceleoCompletionProposals) {
        Objects.requireNonNull(acceleoCompletionProposals);
        return acceleoCompletionProposals.stream().map(acceleoCompletionProposal -> {
            String text = acceleoCompletionProposal.getText();
            if (text != null) {
                CompletionItem completionItem = new CompletionItem();
                String proposalDescription = acceleoCompletionProposal.getDescription();
                if (proposalDescription != null) {
                    completionItem.setDocumentation(proposalDescription);
                } else {
                    completionItem.setDocumentation(text);
                }
                completionItem.setInsertText(text);
                completionItem.setLabel(acceleoCompletionProposal.getLabel());
                completionItem.setKind(AcceleoLanguageServerServicesUtils.getKind(acceleoCompletionProposal));
                String sortText = String.join((CharSequence)"", Collections.nCopies(acceleoCompletionProposals.indexOf(acceleoCompletionProposal), "a"));
                completionItem.setSortText(sortText);
                return completionItem;
            }
            throw new IllegalArgumentException("The text proposed by an " + acceleoCompletionProposal.getClass().getCanonicalName() + " should not be null.");
        }).collect(Collectors.toList());
    }

    private static CompletionItemKind getKind(AcceleoCompletionProposal acceleoCompletionProposal) {
        EClass acceleoType;
        CompletionItemKind completionItemKind = acceleoCompletionProposal instanceof AcceleoCodeTemplateCompletionProposal ? CompletionItemKind.Snippet : ((acceleoType = acceleoCompletionProposal.getAcceleoType()) == null ? CompletionItemKind.Text : new AcceleoAstNodeToCompletionItemKind().doSwitchOnType(acceleoCompletionProposal.getAcceleoType()));
        return completionItemKind;
    }

    public static DocumentSymbol transform(AcceleoSymbol acceleoSymbol, String acceleoSourceContents) {
        Objects.requireNonNull(acceleoSymbol);
        int startPosition = acceleoSymbol.getAcceleoValidationResult().getAcceleoAstResult().getStartPosition((ASTNode)acceleoSymbol.getSemanticElement());
        int endPosition = acceleoSymbol.getAcceleoValidationResult().getAcceleoAstResult().getEndPosition((ASTNode)acceleoSymbol.getSemanticElement());
        Range range = AcceleoLanguageServerPositionUtils.getCorrespondingRange(startPosition, endPosition, acceleoSourceContents);
        String symbolName = acceleoSymbol.getName();
        if (acceleoSymbol.getDetails() != null) {
            symbolName = String.valueOf(symbolName) + " : ";
        }
        DocumentSymbol documentSymbol = new DocumentSymbol(symbolName, AcceleoLanguageServerServicesUtils.getKind(acceleoSymbol), range, range, acceleoSymbol.getDetails(), acceleoSymbol.getChildren().stream().map(childAcceleoSymbol -> AcceleoLanguageServerServicesUtils.transform(childAcceleoSymbol, acceleoSourceContents)).collect(Collectors.toList()));
        return documentSymbol;
    }

    private static SymbolKind getKind(AcceleoSymbol acceleoSymbol) {
        return (SymbolKind)new AcceleoAstNodeToSymbolKind(acceleoSymbol.getAcceleoValidationResult()).doSwitch((EObject)acceleoSymbol.getSemanticElement());
    }

    public static List<Diagnostic> transform(IAcceleoValidationResult acceleoValidationResults, String acceleoSourceContents) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (acceleoValidationResults != null) {
            diagnostics.addAll(acceleoValidationResults.getValidationMessages().stream().map(acceleoValidationMessage -> AcceleoLanguageServerServicesUtils.transform(acceleoValidationMessage, acceleoSourceContents)).collect(Collectors.toList()));
        } else {
            diagnostics.add(AcceleoLanguageServerServicesUtils.getNullValidationDiagnosticFor(acceleoSourceContents));
        }
        return diagnostics;
    }

    private static Diagnostic transform(IValidationMessage acceleoValidationMessage, String acceleoSourceContents) {
        int startPosition = acceleoValidationMessage.getStartPosition();
        int endPosition = acceleoValidationMessage.getEndPosition();
        Range range = AcceleoLanguageServerPositionUtils.getCorrespondingRange(startPosition, endPosition, acceleoSourceContents);
        String message = acceleoValidationMessage.getMessage();
        DiagnosticSeverity severity = AcceleoLanguageServerServicesUtils.transform(acceleoValidationMessage.getLevel());
        String source = "Acceleo Validation";
        return new Diagnostic(range, message, severity, source);
    }

    private static Diagnostic getNullValidationDiagnosticFor(String documentContents) {
        int startPosition = 0;
        int endPosition = documentContents.length() - 1;
        Range range = AcceleoLanguageServerPositionUtils.getCorrespondingRange(startPosition, endPosition, documentContents);
        String message = "The Acceleo validation could not be performed on this document.";
        DiagnosticSeverity severity = DiagnosticSeverity.Warning;
        String source = "Acceleo Validation";
        return new Diagnostic(range, message, severity, source);
    }

    private static DiagnosticSeverity transform(ValidationMessageLevel acceleoValidationMessageLevel) {
        DiagnosticSeverity diagnosticSeverity = null;
        switch (acceleoValidationMessageLevel) {
            case INFO: {
                diagnosticSeverity = DiagnosticSeverity.Information;
                break;
            }
            case WARNING: {
                diagnosticSeverity = DiagnosticSeverity.Warning;
                break;
            }
            case ERROR: {
                diagnosticSeverity = DiagnosticSeverity.Error;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported " + ValidationMessageLevel.class.getCanonicalName() + " literal: " + acceleoValidationMessageLevel.toString());
            }
        }
        return diagnosticSeverity;
    }
}

