/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;

public class NumberServices {
    private static final String CAN_T_DIVIDE_BY_ZERO = "Can't divide by zero.";

    @Documentation(value="Performs the negation of the specified argument.", params={@Param(name="self", value="The argument to be negated.")}, result="The negation of the argument.", examples={@Example(expression="1.unaryMin()", result="-1"), @Example(expression="-1.unaryMin()", result="1")}, comment="You can use \"-expression\" for the same result.")
    public Integer unaryMin(Integer self) {
        return -self.intValue();
    }

    public Integer add(Integer a, Integer b) {
        return a + b;
    }

    public Integer sub(Integer a, Integer b) {
        return a - b;
    }

    public Integer mult(Integer a, Integer b) {
        return a * b;
    }

    public Integer divOp(Integer a, Integer b) {
        return a / b;
    }

    public Double add(Double a, Double b) {
        return a + b;
    }

    public Double sub(Double a, Double b) {
        return a - b;
    }

    public Double mult(Double a, Double b) {
        return a * b;
    }

    public Double divOp(Double a, Double b) {
        return a / b;
    }

    @Documentation(value="Performs the negation of the specified argument.", params={@Param(name="self", value="The argument to be negated.")}, result="The negation of the argument.", examples={@Example(expression="3.14.unaryMin()", result="-3.14"), @Example(expression="-3.14.unaryMin()", result="3.14")}, comment="You can use \"-expression\" for the same result.")
    public Double unaryMin(Double value) {
        return -value.doubleValue();
    }

    @Documentation(value="Returns the absolute value of self, self if it is already a positive number.", params={@Param(name="self", value="The current value.")}, result="The absolute value of self, self if it is already a positive number", examples={@Example(expression="-3.14.abs()", result="3.14"), @Example(expression="3.14.abs()", result="3.14")})
    public Double abs(Double self) {
        return Math.abs(self);
    }

    @Documentation(value="Returns the absolute value of self, self if it is already a positive number.", params={@Param(name="self", value="The current value.")}, result="The absolute value of self, self if it is already a positive number", examples={@Example(expression="-3.abs()", result="3"), @Example(expression="3.abs()", result="3")})
    public Integer abs(Integer self) {
        return Math.abs(self);
    }

    @Documentation(value="Returns the integer part of self.", params={@Param(name="self", value="The current value.")}, result="The integer part of self.", examples={@Example(expression="3.14.floor()", result="3"), @Example(expression="3.66.floor()", result="3")})
    public Integer floor(Double self) {
        return (int)Math.floor(self);
    }

    @Documentation(value="Returns self.", params={@Param(name="self", value="The current value.")}, result="Self.", examples={@Example(expression="3.floor()", result="3")})
    public Integer floor(Integer self) {
        return self;
    }

    @Documentation(value="Returns the greatest number between self and r.", params={@Param(name="self", value="The current value."), @Param(name="r", value="The other value.")}, result="The greatest number between self and r.", examples={@Example(expression="3.max(6)", result="6"), @Example(expression="6.max(3)", result="6")})
    public Integer max(Integer self, Integer r) {
        return Math.max(self, r);
    }

    @Documentation(value="Returns the greatest number between self and r.", params={@Param(name="self", value="The current value."), @Param(name="r", value="The other value.")}, result="The greatest number between self and r.", examples={@Example(expression="3.14.max(6.7)", result="6.7"), @Example(expression="6.7.max(3.14)", result="6.7")})
    public Double max(Double self, Double r) {
        return Math.max(self, r);
    }

    @Documentation(value="Returns the lowest number between self and r.", params={@Param(name="self", value="The current value."), @Param(name="r", value="The other value.")}, result="The lowest number between self and r.", examples={@Example(expression="3.min(6)", result="3"), @Example(expression="6.min(3)", result="3")})
    public Integer min(Integer self, Integer r) {
        return Math.min(self, r);
    }

    @Documentation(value="Returns the lowest number between self and r.", params={@Param(name="self", value="The current value."), @Param(name="r", value="The other value.")}, result="The lowest number between self and r.", examples={@Example(expression="3.14.min(6.7)", result="3.14"), @Example(expression="6.7.min(3.14)", result="3.14")})
    public Double min(Double self, Double r) {
        return Math.min(self, r);
    }

    @Documentation(value="Returns the nearest integer to self.", params={@Param(name="self", value="The current value.")}, result="The nearest integer to self.", examples={@Example(expression="3.14.round()", result="3"), @Example(expression="3.66.round()", result="4")})
    public Integer round(Double self) {
        return (int)Math.round(self);
    }

    @Documentation(value="Returns self.", params={@Param(name="self", value="The current value.")}, result="Self.", examples={@Example(expression="3.round()", result="3")})
    public Integer round(Integer self) {
        return self;
    }

    @Documentation(value="Returns the integer quotient of the division of self by i.", params={@Param(name="self", value="The current value."), @Param(name="i", value="The divider.")}, result="The integer quotient of the division of self by i.", examples={@Example(expression="6.9.div(3.1)", result="2")})
    public Integer div(Double self, Double i) {
        if (i.equals(0.0)) {
            throw new IllegalArgumentException(CAN_T_DIVIDE_BY_ZERO);
        }
        return (int)(self / i);
    }

    @Documentation(value="Returns the integer quotient of the division of self by i.", params={@Param(name="self", value="The current value."), @Param(name="i", value="The divider.")}, result="The integer quotient of the division of self by i.", examples={@Example(expression="7.div(3)", result="2")})
    public Integer div(Integer self, Integer i) {
        if (i.equals(0)) {
            throw new IllegalArgumentException(CAN_T_DIVIDE_BY_ZERO);
        }
        return self / i;
    }

    @Documentation(value="Returns the integer remainder of the division of self by i.", params={@Param(name="self", value="The current value."), @Param(name="i", value="The divider.")}, result="The integer remainder of the division of self by i.", examples={@Example(expression="7.5.div(3.1)", result="1")})
    public Integer mod(Double self, Double i) {
        if (i.equals(0.0)) {
            throw new IllegalArgumentException(CAN_T_DIVIDE_BY_ZERO);
        }
        return (int)Math.ceil(self % i);
    }

    @Documentation(value="Returns the integer remainder of the division of self by i.", params={@Param(name="self", value="The current value."), @Param(name="i", value="The divider.")}, result="The integer remainder of the division of self by i.", examples={@Example(expression="7.div(3)", result="1")})
    public Integer mod(Integer self, Integer i) {
        if (i.equals(0)) {
            throw new IllegalArgumentException(CAN_T_DIVIDE_BY_ZERO);
        }
        return self % i;
    }

    @Documentation(value="Performs the negation of the specified argument.", params={@Param(name="self", value="The argument to be negated.")}, result="The negation of the argument.", examples={@Example(expression="1.unaryMin()", result="-1"), @Example(expression="-1.unaryMin()", result="1")}, comment="You can use \"-expression\" for the same result.")
    public Long unaryMin(Long self) {
        return -self.longValue();
    }

    public Long add(Long a, Long b) {
        return a + b;
    }

    public Long sub(Long a, Long b) {
        return a - b;
    }

    public Long mult(Long a, Long b) {
        return a * b;
    }

    public Long divOp(Long a, Long b) {
        return a / b;
    }

    public Float add(Float a, Float b) {
        return Float.valueOf(a.floatValue() + b.floatValue());
    }

    public Float sub(Float a, Float b) {
        return Float.valueOf(a.floatValue() - b.floatValue());
    }

    public Float mult(Float a, Float b) {
        return Float.valueOf(a.floatValue() * b.floatValue());
    }

    public Float divOp(Float a, Float b) {
        return Float.valueOf(a.floatValue() / b.floatValue());
    }

    @Documentation(value="Performs the negation of the specified argument.", params={@Param(name="self", value="The argument to be negated.")}, result="The negation of the argument.", examples={@Example(expression="3.14.unaryMin()", result="-3.14"), @Example(expression="-3.14.unaryMin()", result="3.14")}, comment="You can use \"-expression\" for the same result.")
    public Float unaryMin(Float value) {
        return Float.valueOf(-value.floatValue());
    }

    @Documentation(value="Returns the absolute value of self, self if it is already a positive number.", params={@Param(name="self", value="The current value.")}, result="The absolute value of self, self if it is already a positive number", examples={@Example(expression="-3.14.abs()", result="3.14"), @Example(expression="3.14.abs()", result="3.14")})
    public Float abs(Float self) {
        return Float.valueOf(Math.abs(self.floatValue()));
    }

    @Documentation(value="Returns the absolute value of self, self if it is already a positive number.", params={@Param(name="self", value="The current value.")}, result="The absolute value of self, self if it is already a positive number", examples={@Example(expression="-3.abs()", result="3"), @Example(expression="3.abs()", result="3")})
    public Long abs(Long self) {
        return Math.abs(self);
    }

    @Documentation(value="Returns the integer part of self.", params={@Param(name="self", value="The current value.")}, result="The integer part of self.", examples={@Example(expression="3.14.floor()", result="3"), @Example(expression="3.66.floor()", result="3")})
    public Integer floor(Float self) {
        return (int)Math.floor(self.floatValue());
    }

    @Documentation(value="Returns self.", params={@Param(name="self", value="The current value.")}, result="Self.", examples={@Example(expression="3.floor()", result="3")})
    public Long floor(Long self) {
        return self;
    }

    @Documentation(value="Returns the greatest number between self and r.", params={@Param(name="self", value="The current value."), @Param(name="r", value="The other value.")}, result="The greatest number between self and r.", examples={@Example(expression="3.max(6)", result="6"), @Example(expression="6.max(3)", result="6")})
    public Long max(Long self, Long r) {
        return Math.max(self, r);
    }

    @Documentation(value="Returns the greatest number between self and r.", params={@Param(name="self", value="The current value."), @Param(name="r", value="The other value.")}, result="The greatest number between self and r.", examples={@Example(expression="3.14.max(6.7)", result="6.7"), @Example(expression="6.7.max(3.14)", result="6.7")})
    public Float max(Float self, Float r) {
        return Float.valueOf(Math.max(self.floatValue(), r.floatValue()));
    }

    @Documentation(value="Returns the lowest number between self and r.", params={@Param(name="self", value="The current value."), @Param(name="r", value="The other value.")}, result="The lowest number between self and r.", examples={@Example(expression="3.min(6)", result="3"), @Example(expression="6.min(3)", result="3")})
    public Long min(Long self, Long r) {
        return Math.min(self, r);
    }

    @Documentation(value="Returns the lowest number between self and r.", params={@Param(name="self", value="The current value."), @Param(name="r", value="The other value.")}, result="The lowest number between self and r.", examples={@Example(expression="3.14.min(6.7)", result="3.14"), @Example(expression="6.7.min(3.14)", result="3.14")})
    public Float min(Float self, Float r) {
        return Float.valueOf(Math.min(self.floatValue(), r.floatValue()));
    }

    @Documentation(value="Returns the nearest integer to self.", params={@Param(name="self", value="The current value.")}, result="The nearest integer to self.", examples={@Example(expression="3.14.round()", result="3"), @Example(expression="3.66.round()", result="4")})
    public Integer round(Float self) {
        return Math.round(self.floatValue());
    }

    @Documentation(value="Returns self.", params={@Param(name="self", value="The current value.")}, result="Self.", examples={@Example(expression="3.round()", result="3")})
    public Long round(Long self) {
        return self;
    }

    @Documentation(value="Returns the long quotient of the division of self by i.", params={@Param(name="self", value="The current value."), @Param(name="i", value="The divider.")}, result="The integer quotient of the division of self by i.", examples={@Example(expression="6.9.div(3.1)", result="2")})
    public Integer div(Float self, Float i) {
        if (i.equals(Float.valueOf(0.0f))) {
            throw new IllegalArgumentException(CAN_T_DIVIDE_BY_ZERO);
        }
        return (int)(self.floatValue() / i.floatValue());
    }

    @Documentation(value="Returns the long quotient of the division of self by i.", params={@Param(name="self", value="The current value."), @Param(name="i", value="The divider.")}, result="The long quotient of the division of self by i.", examples={@Example(expression="7.div(3)", result="2")})
    public Long div(Long self, Long i) {
        if (i.equals(0L)) {
            throw new IllegalArgumentException(CAN_T_DIVIDE_BY_ZERO);
        }
        return self / i;
    }

    @Documentation(value="Returns the integer remainder of the division of self by i.", params={@Param(name="self", value="The current value."), @Param(name="i", value="The divider.")}, result="The integer remainder of the division of self by i.", examples={@Example(expression="7.5.div(3.1)", result="1")})
    public Integer mod(Float self, Float i) {
        if (i.equals(Float.valueOf(0.0f))) {
            throw new IllegalArgumentException(CAN_T_DIVIDE_BY_ZERO);
        }
        return (int)Math.ceil(self.floatValue() % i.floatValue());
    }

    @Documentation(value="Returns the long remainder of the division of self by i.", params={@Param(name="self", value="The current value."), @Param(name="i", value="The divider.")}, result="The long remainder of the division of self by i.", examples={@Example(expression="7.div(3)", result="1")})
    public Long mod(Long self, Long i) {
        if (i.equals(0L)) {
            throw new IllegalArgumentException(CAN_T_DIVIDE_BY_ZERO);
        }
        return self % i;
    }

    @Documentation(value="Returns the double value of the given double.", params={@Param(name="self", value="The current value.")}, result="The double value.", examples={@Example(expression="1.0.toDouble()", result="1.0")})
    public Double toDouble(Double self) {
        return (double)self;
    }

    @Documentation(value="Returns the double value of the given integer.", params={@Param(name="self", value="The current value.")}, result="The double value.", examples={@Example(expression="1.toDouble()", result="1.0")})
    public Double toDouble(Integer self) {
        return (double)self;
    }

    @Documentation(value="Returns the double value of the given float.", params={@Param(name="self", value="The current value.")}, result="The double value.", examples={@Example(expression="1.0.toDouble()", result="1.0")})
    public Double toDouble(Float self) {
        return self.floatValue();
    }

    @Documentation(value="Returns the long value of the given long.", params={@Param(name="self", value="The current value.")}, result="The long value.", examples={@Example(expression="1.toLong()", result="1")})
    public Long toLong(Long self) {
        return (long)self;
    }

    @Documentation(value="Returns the long value of the given integer.", params={@Param(name="self", value="The current value.")}, result="The long value.", examples={@Example(expression="1.toLong()", result="1")})
    public Long toLong(Integer self) {
        return (long)self;
    }
}

