/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.namespace;

import org.eclipse.acceleo.query.runtime.namespace.ILoader;

public abstract class AbstractLoader
implements ILoader {
    protected static final String SLASH = "/";
    protected static final String DOT = ".";
    private final String qualifierSeparator;
    private final String fileExtension;
    private final String sourceFileExtension;

    public AbstractLoader(String qualifierSeparator, String fileExtension, String sourceFileExtension) {
        this.qualifierSeparator = qualifierSeparator;
        this.fileExtension = fileExtension;
        this.sourceFileExtension = sourceFileExtension;
    }

    @Override
    public String qualifiedName(String resourceName) {
        String res = resourceName.endsWith(DOT + this.fileExtension) ? resourceName.replace(SLASH, this.qualifierSeparator).substring(0, resourceName.length() - (this.fileExtension.length() + 1)) : null;
        return res;
    }

    @Override
    public String resourceName(String qualifiedName) {
        return String.valueOf(qualifiedName.replace(this.qualifierSeparator, SLASH)) + DOT + this.fileExtension;
    }

    @Override
    public String sourceResourceName(String qualifiedName) {
        return String.valueOf(qualifiedName.replace(this.qualifierSeparator, SLASH)) + DOT + this.sourceFileExtension;
    }
}

