/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.jdt;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.query.ide.jdt.Activator;
import org.eclipse.acceleo.query.ide.runtime.impl.namespace.EclipseQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.impl.namespace.ClassLoaderQualifiedNameResolver;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;

public class EclipseJDTQualifiedNameResolver
extends ClassLoaderQualifiedNameResolver {
    private final IJavaProject project;

    public EclipseJDTQualifiedNameResolver(ClassLoader classLoader, IProject project, String qualifierSeparator) {
        super(EclipseJDTQualifiedNameResolver.createProjectClassLoader(classLoader, project), qualifierSeparator);
        this.project = JavaCore.create((IProject)project);
    }

    protected static ClassLoader createProjectClassLoader(ClassLoader classLoader, IProject project) {
        ClassLoader res;
        if (project.exists() && project.isOpen()) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                try {
                    String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
                    ArrayList<URL> urlList = new ArrayList<URL>();
                    String[] stringArray = classPathEntries;
                    int n = classPathEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String entry = stringArray[n2];
                        Path path = new Path(entry);
                        URL url = path.toFile().toURI().toURL();
                        urlList.add(url);
                        ++n2;
                    }
                    URL[] urls = urlList.toArray(new URL[urlList.size()]);
                    res = new URLClassLoader(urls, classLoader);
                }
                catch (CoreException e) {
                    Activator.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.aql.ide.jdt", "can't load from workspace.", (Throwable)e));
                    res = EclipseQualifiedNameResolver.createProjectClassLoader((ClassLoader)classLoader, (IProject)project);
                }
                catch (MalformedURLException e) {
                    Activator.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.aql.ide.jdt", "can't load from workspace.", (Throwable)e));
                    res = EclipseQualifiedNameResolver.createProjectClassLoader((ClassLoader)classLoader, (IProject)project);
                }
            } else {
                res = EclipseQualifiedNameResolver.createProjectClassLoader((ClassLoader)classLoader, (IProject)project);
            }
        } else {
            res = classLoader;
        }
        return res;
    }

    public URL getSourceURL(String qualifiedName) {
        URL res;
        block5: {
            if (this.project != null) {
                try {
                    URL foundURL = this.getSourceURL(this.project, qualifiedName);
                    if (foundURL != null) {
                        res = foundURL;
                        break block5;
                    }
                    res = super.getSourceURL(qualifiedName);
                }
                catch (JavaModelException e) {
                    res = super.getSourceURL(qualifiedName);
                }
            } else {
                res = super.getSourceURL(qualifiedName);
            }
        }
        return res;
    }

    private URL getSourceURL(IJavaProject javaProject, String qualifiedName) throws JavaModelException {
        URL res = null;
        IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        block4: while (n2 < n) {
            IProject childProject;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                try {
                    File workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
                    URI srcFolderURI = new URI(String.valueOf(workspaceRoot.toURI().toString().substring(0, workspaceRoot.toURI().toString().length() - 1)) + entry.getPath().toString());
                    List relativePathes = this.getPossibleResourceNames(qualifiedName);
                    for (String relativePath : relativePathes) {
                        URI uri = new URI(String.valueOf(srcFolderURI.toString()) + "/" + relativePath);
                        File file = new File(uri);
                        if (!file.isFile() || !file.exists()) continue;
                        try {
                            res = file.toURI().toURL();
                            break block4;
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                }
                catch (URISyntaxException workspaceRoot) {}
            } else if (entry.getEntryKind() == 2 && (childProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().lastSegment())) != null) {
                IJavaProject childJavaProject = JavaCore.create((IProject)childProject);
                res = this.getSourceURL(childJavaProject, qualifiedName);
            }
            ++n2;
        }
        return res;
    }
}

