/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.service;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.event.AbstractAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.AcceleoEngine;
import org.eclipse.acceleo.engine.generation.IAcceleoEngine;
import org.eclipse.acceleo.engine.generation.strategy.DefaultStrategy;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.generation.strategy.PreviewStrategy;
import org.eclipse.acceleo.engine.internal.utils.AcceleoEngineRegistry;
import org.eclipse.acceleo.engine.internal.utils.AcceleoListenerDescriptor;
import org.eclipse.acceleo.engine.internal.utils.AcceleoTraceabilityRegistryListenerUils;
import org.eclipse.acceleo.engine.internal.utils.DefaultEngineSelector;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.VisibilityKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.Variable;

public final class AcceleoService {
    private static final List<IAcceleoTextGenerationListener> STATIC_LISTENERS = new ArrayList<IAcceleoTextGenerationListener>();
    private static final String TEMPLATE_CALL_NPE = AcceleoEngineMessages.getString("AcceleoService.NullArguments");
    private static final String UNDEFINED_TEMPLATE = "AcceleoService.UndefinedTemplate";
    private IAcceleoEngine generationEngine;
    private final IAcceleoGenerationStrategy strategy;
    private final List<IAcceleoTextGenerationListener> addedListeners = new ArrayList<IAcceleoTextGenerationListener>();
    private final List<String> addedPropertiesfiles = new ArrayList<String>();
    private final List<Map<String, String>> addedProperties = new ArrayList<Map<String, String>>();
    private String generationID;
    private boolean deactivateTraceability;
    private boolean generationHasOccurred;
    private boolean generationIsOccurring;
    private List<AcceleoListenerDescriptor> descriptorsUsed;
    private boolean forceTraceability;

    public AcceleoService() {
        this(null);
    }

    public AcceleoService(IAcceleoGenerationStrategy generationStrategy) {
        this.strategy = generationStrategy == null ? new DefaultStrategy() : generationStrategy;
        this.createEngine();
    }

    public static void addStaticListener(IAcceleoTextGenerationListener listener) {
        STATIC_LISTENERS.add(listener);
    }

    public static void removeStaticListener(IAcceleoTextGenerationListener listener) {
        STATIC_LISTENERS.remove(listener);
    }

    public void addListener(IAcceleoTextGenerationListener listener) {
        this.generationEngine.addListener(listener);
        this.addedListeners.add(listener);
    }

    public void addProperties(Map<String, String> customProperties) {
        this.generationEngine.addProperties(customProperties);
        this.addedProperties.add(customProperties);
    }

    public void addPropertiesFile(String propertiesFile) throws MissingResourceException {
        this.generationEngine.addProperties(propertiesFile);
        this.addedPropertiesfiles.add(propertiesFile);
    }

    public void addProperties(PropertyResourceBundle resourceBundle, String fileName) {
        if (this.generationEngine instanceof AcceleoEngine) {
            AcceleoEngine engine = (AcceleoEngine)this.generationEngine;
            engine.addProperties(resourceBundle, fileName);
        }
    }

    @Deprecated
    public void dispose() {
    }

    public Map<String, String> doGenerate(Map<Module, Set<String>> templates, EObject model, File generationRoot, Monitor monitor) {
        return this.doGenerate(templates, model, true, generationRoot, monitor);
    }

    public Map<String, String> doGenerate(Map<Module, Set<String>> templates, EObject model, boolean recursive, File generationRoot, Monitor monitor) {
        if (templates == null || model == null || !(this.strategy instanceof PreviewStrategy) && generationRoot == null) {
            throw new NullPointerException(TEMPLATE_CALL_NPE);
        }
        HashMap<EClassifier, CompactHashSet> templateTypes = new HashMap<EClassifier, CompactHashSet>();
        for (Map.Entry<Module, Set<String>> entry : templates.entrySet()) {
            for (String string : entry.getValue()) {
                List<Template> list = this.findTemplates(entry.getKey(), string, 1);
                for (Template template : list) {
                    EClassifier templateType = (EClassifier)((Variable)template.getParameter().get(0)).getType();
                    if (templateTypes.containsKey(templateType)) {
                        ((Set)templateTypes.get(templateType)).add(template);
                        continue;
                    }
                    CompactHashSet temp = new CompactHashSet();
                    temp.add(template);
                    templateTypes.put(templateType, temp);
                }
            }
        }
        HashMap<String, String> previewResult = new HashMap<String, String>();
        this.generationIsOccurring = true;
        this.prepareGeneration(monitor, generationRoot);
        ArrayList<EObject> arguments = new ArrayList<EObject>();
        arguments.add(model);
        for (Map.Entry entry : templateTypes.entrySet()) {
            if (!((EClassifier)entry.getKey()).isInstance((Object)model)) continue;
            for (Template template : (Set)entry.getValue()) {
                previewResult.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
                this.generationHasOccurred = true;
            }
        }
        if (recursive) {
            TreeIterator treeIterator = model.eAllContents();
            while (treeIterator.hasNext()) {
                EObject potentialTarget = (EObject)treeIterator.next();
                for (Map.Entry entry : templateTypes.entrySet()) {
                    if (!((EClassifier)entry.getKey()).isInstance((Object)potentialTarget)) continue;
                    arguments.clear();
                    arguments.add(potentialTarget);
                    for (Template template : (Set)entry.getValue()) {
                        previewResult.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
                        this.generationHasOccurred = true;
                    }
                }
            }
        }
        this.generationIsOccurring = false;
        this.finalizeGeneration();
        this.clearCaches();
        return previewResult;
    }

    public Map<String, String> doGenerate(Module module, String templateName, EObject model, File generationRoot, boolean blockTraceability, Monitor monitor) {
        this.deactivateTraceability = blockTraceability;
        HashMap<String, String> result = new HashMap<String, String>();
        List<Template> templates = this.findTemplates(module, templateName, 1);
        this.generationIsOccurring = true;
        this.prepareGeneration(monitor, generationRoot);
        for (Template template : templates) {
            result.putAll(this.doGenerate(template, model, generationRoot, monitor));
        }
        this.generationIsOccurring = false;
        this.finalizeGeneration();
        return result;
    }

    public Map<String, String> doGenerate(Module module, String templateName, EObject model, File generationRoot, Monitor monitor) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<Template> templates = this.findTemplates(module, templateName, 1);
        this.generationIsOccurring = true;
        this.prepareGeneration(monitor, generationRoot);
        for (Template template : templates) {
            result.putAll(this.doGenerate(template, model, generationRoot, monitor));
        }
        this.generationIsOccurring = false;
        this.finalizeGeneration();
        return result;
    }

    public Map<String, String> doGenerate(Module module, String templateName, EObject model, List<? extends Object> arguments, File generationRoot, Monitor monitor) {
        return this.doGenerate(module, templateName, model, true, arguments, generationRoot, monitor);
    }

    public Map<String, String> doGenerate(Module module, String templateName, EObject model, boolean recursive, List<? extends Object> arguments, File generationRoot, Monitor monitor) {
        boolean shouldNotify = false;
        if (!this.generationIsOccurring) {
            this.generationIsOccurring = true;
            shouldNotify = true;
            this.prepareGeneration(monitor, generationRoot);
        }
        if (model == null || arguments == null || !(this.strategy instanceof PreviewStrategy) && generationRoot == null) {
            throw new NullPointerException(TEMPLATE_CALL_NPE);
        }
        List<Template> templates = this.findTemplates(module, templateName, arguments.size() + 1);
        ArrayList<Template> mainTemplates = new ArrayList<Template>();
        for (Template template : templates) {
            if (!template.isMain()) continue;
            mainTemplates.add(template);
        }
        HashMap<String, String> previewResult = new HashMap<String, String>();
        for (Template template : mainTemplates) {
            EClassifier argumentType = (EClassifier)((Variable)template.getParameter().get(0)).getType();
            if (argumentType.eIsProxy()) {
                throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoService.TypeIsProxy", templateName));
            }
            if (argumentType.isInstance((Object)model)) {
                ArrayList<? extends Object> actualArguments = new ArrayList<Object>();
                actualArguments.add(model);
                actualArguments.addAll(arguments);
                previewResult.putAll(this.doGenerateTemplate(template, actualArguments, generationRoot, monitor));
                this.generationHasOccurred = true;
            }
            if (recursive) {
                TreeIterator targetElements = model.eAllContents();
                while (targetElements.hasNext()) {
                    EObject potentialTarget = (EObject)targetElements.next();
                    if (!argumentType.isInstance((Object)potentialTarget)) continue;
                    ArrayList<? extends Object> actualArguments = new ArrayList<Object>();
                    actualArguments.add(potentialTarget);
                    actualArguments.addAll(arguments);
                    previewResult.putAll(this.doGenerateTemplate(template, actualArguments, generationRoot, monitor));
                    this.generationHasOccurred = true;
                }
            }
            if (model.eResource() == null) continue;
            ArrayList roots = new ArrayList(model.eResource().getContents());
            roots.remove(model);
            for (EObject root : roots) {
                if (!argumentType.isInstance((Object)root)) continue;
                ArrayList<? extends Object> actualArguments = new ArrayList<Object>();
                actualArguments.add(root);
                actualArguments.addAll(arguments);
                previewResult.putAll(this.doGenerateTemplate(template, actualArguments, generationRoot, monitor));
                this.generationHasOccurred = true;
            }
        }
        if (shouldNotify) {
            shouldNotify = false;
            this.generationIsOccurring = false;
            this.finalizeGeneration();
        }
        return previewResult;
    }

    public Map<String, String> doGenerate(Module module, String templateName, EObject model, List<? extends Object> arguments, File generationRoot, boolean blockTraceability, Monitor monitor) {
        this.deactivateTraceability = blockTraceability;
        return this.doGenerate(module, templateName, model, arguments, generationRoot, monitor);
    }

    public Map<String, String> doGenerate(Template template, EObject model, File generationRoot, Monitor monitor) {
        return this.doGenerate(template, model, true, generationRoot, monitor);
    }

    public Map<String, String> doGenerate(Template template, EObject model, boolean recursive, File generationRoot, Monitor monitor) {
        boolean shouldNotify = false;
        if (!this.generationIsOccurring) {
            this.generationIsOccurring = true;
            shouldNotify = true;
            this.prepareGeneration(monitor, generationRoot);
        }
        if (template == null || model == null || !(this.strategy instanceof PreviewStrategy) && generationRoot == null) {
            throw new NullPointerException(TEMPLATE_CALL_NPE);
        }
        if (template.getVisibility() != VisibilityKind.PUBLIC) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.IllegalTemplateInvocation"));
        }
        if (template.getParameter().size() != 1) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.VoidArguments"));
        }
        HashMap<String, String> previewResult = new HashMap<String, String>();
        EClassifier argumentType = (EClassifier)((Variable)template.getParameter().get(0)).getType();
        ArrayList<EObject> arguments = new ArrayList<EObject>();
        if (argumentType.isInstance((Object)model)) {
            arguments.add(model);
            previewResult.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
            this.generationHasOccurred = true;
        }
        if (recursive) {
            TreeIterator targetElements = model.eAllContents();
            while (targetElements.hasNext()) {
                EObject potentialTarget = (EObject)targetElements.next();
                if (!argumentType.isInstance((Object)potentialTarget)) continue;
                arguments.clear();
                arguments.add(potentialTarget);
                previewResult.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
                this.generationHasOccurred = true;
            }
        }
        if (shouldNotify) {
            this.generationIsOccurring = false;
            shouldNotify = false;
            this.finalizeGeneration();
        }
        this.clearCaches();
        return previewResult;
    }

    public Map<String, String> doGenerateTemplate(Module module, String templateName, List<? extends Object> arguments, File generationRoot, Monitor monitor) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<Template> templates = this.findTemplates(module, templateName, arguments);
        this.generationIsOccurring = true;
        this.prepareGeneration(monitor, generationRoot);
        for (Template template : templates) {
            result.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
        }
        this.generationIsOccurring = false;
        this.finalizeGeneration();
        return result;
    }

    public Map<String, String> doGenerateTemplate(Template template, List<? extends Object> arguments, File generationRoot, boolean blockTraceability, Monitor monitor) {
        this.deactivateTraceability = blockTraceability;
        return this.doGenerateTemplate(template, arguments, generationRoot, monitor);
    }

    public Map<String, String> doGenerateTemplate(Template template, List<? extends Object> arguments, File generationRoot, Monitor monitor) {
        return this.generationEngine.evaluate(template, arguments, generationRoot, this.strategy, monitor);
    }

    public void doPrepareGeneration(Monitor monitor, File generationRoot) {
        this.generationIsOccurring = true;
        this.prepareGeneration(monitor, generationRoot);
    }

    private void prepareGeneration(Monitor monitor, File generationRoot) {
        this.generationHasOccurred = false;
        for (IAcceleoTextGenerationListener listener : STATIC_LISTENERS) {
            this.generationEngine.addListener(listener);
        }
        this.descriptorsUsed = new ArrayList<AcceleoListenerDescriptor>();
        List<AcceleoListenerDescriptor> descriptors = AcceleoTraceabilityRegistryListenerUils.getListenerDescriptors();
        for (AcceleoListenerDescriptor acceleoListenerDescriptor : descriptors) {
            IContainer[] containers;
            if (acceleoListenerDescriptor.getNature() == null) {
                this.descriptorsUsed.add(acceleoListenerDescriptor);
                continue;
            }
            if (!EMFPlugin.IS_ECLIPSE_RUNNING || generationRoot == null) continue;
            Path location = new Path(generationRoot.getAbsolutePath());
            IContainer[] iContainerArray = containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(location.toFile().toURI());
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer container = iContainerArray[n2];
                IProject project = container.getProject();
                try {
                    if (project != null && project.isAccessible() && project.hasNature(acceleoListenerDescriptor.getNature())) {
                        this.descriptorsUsed.add(acceleoListenerDescriptor);
                    }
                }
                catch (CoreException e) {
                    AcceleoEnginePlugin.log((Exception)((Object)e), false);
                }
                ++n2;
            }
        }
        this.forceTraceability = false;
        if (!this.deactivateTraceability) {
            for (AcceleoListenerDescriptor acceleoListenerDescriptor : this.descriptorsUsed) {
                IAcceleoTextGenerationListener listener = acceleoListenerDescriptor.getTraceabilityListener();
                if (listener instanceof AbstractAcceleoTextGenerationListener) {
                    AbstractAcceleoTextGenerationListener textGenerationListener = (AbstractAcceleoTextGenerationListener)listener;
                    textGenerationListener.setGenerationID(this.generationID);
                }
                if (!EMFPlugin.IS_ECLIPSE_RUNNING || AcceleoPreferences.isTraceabilityEnabled() || !acceleoListenerDescriptor.isForceTraceability()) continue;
                AcceleoPreferences.switchTraceability((boolean)true);
                this.forceTraceability = true;
            }
            if (this.forceTraceability) {
                this.createEngine();
                for (IAcceleoTextGenerationListener iAcceleoTextGenerationListener : this.addedListeners) {
                    this.generationEngine.addListener(iAcceleoTextGenerationListener);
                }
                for (Map map : this.addedProperties) {
                    this.generationEngine.addProperties(map);
                }
                for (String string : this.addedPropertiesfiles) {
                    this.generationEngine.addProperties(string);
                }
            }
        }
        for (AcceleoListenerDescriptor acceleoListenerDescriptor : this.descriptorsUsed) {
            this.generationEngine.addListener(acceleoListenerDescriptor.getTraceabilityListener());
        }
        ArrayList<IAcceleoTextGenerationListener> arrayList = new ArrayList<IAcceleoTextGenerationListener>();
        arrayList.addAll(STATIC_LISTENERS);
        arrayList.addAll(this.addedListeners);
        for (AcceleoListenerDescriptor acceleoListenerDescriptor : this.descriptorsUsed) {
            arrayList.add(acceleoListenerDescriptor.getTraceabilityListener());
        }
        for (IAcceleoTextGenerationListener listener : arrayList) {
            if (!(listener instanceof AbstractAcceleoTextGenerationListener)) continue;
            AbstractAcceleoTextGenerationListener abstractListener = (AbstractAcceleoTextGenerationListener)listener;
            abstractListener.generationStart(monitor, generationRoot);
        }
    }

    public void finalizeGeneration() {
        ArrayList<IAcceleoTextGenerationListener> listeners = new ArrayList<IAcceleoTextGenerationListener>();
        listeners.addAll(STATIC_LISTENERS);
        listeners.addAll(this.addedListeners);
        for (AcceleoListenerDescriptor acceleoListenerDescriptor : this.descriptorsUsed) {
            listeners.add(acceleoListenerDescriptor.getTraceabilityListener());
        }
        for (IAcceleoTextGenerationListener listener : listeners) {
            if (!(listener instanceof AbstractAcceleoTextGenerationListener)) continue;
            AbstractAcceleoTextGenerationListener abstractListener = (AbstractAcceleoTextGenerationListener)listener;
            abstractListener.generationCompleted();
        }
        for (IAcceleoTextGenerationListener listener : STATIC_LISTENERS) {
            this.generationEngine.removeListener(listener);
        }
        for (AcceleoListenerDescriptor acceleoListenerDescriptor : this.descriptorsUsed) {
            this.generationEngine.removeListener(acceleoListenerDescriptor.getTraceabilityListener());
        }
        for (IAcceleoTextGenerationListener listener : this.addedListeners) {
            this.generationEngine.removeListener(listener);
        }
        if (EMFPlugin.IS_ECLIPSE_RUNNING && this.forceTraceability) {
            AcceleoPreferences.switchTraceability((boolean)false);
        }
        this.strategy.dispose();
    }

    public void clearCaches() {
        this.addedListeners.clear();
        this.addedProperties.clear();
        this.addedPropertiesfiles.clear();
    }

    public void removeListener(IAcceleoTextGenerationListener listener) {
        this.generationEngine.removeListener(listener);
    }

    private void createEngine() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.generationEngine = new DefaultEngineSelector().selectEngine(AcceleoEngineRegistry.getRegisteredCreators());
        }
        if (this.generationEngine == null) {
            this.generationEngine = new AcceleoEngine();
        }
    }

    private List<Template> findTemplates(Module module, String templateName, int argumentCount) {
        ArrayList<Template> templates = new ArrayList<Template>();
        for (ModuleElement element : module.getOwnedModuleElement()) {
            Template template;
            if (!(element instanceof Template) || (template = (Template)element).getVisibility() != VisibilityKind.PUBLIC || !templateName.equals(template.getName()) || template.getParameter().size() != argumentCount) continue;
            templates.add(template);
        }
        if (templates.isEmpty()) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString(UNDEFINED_TEMPLATE, templateName, module.getName()));
        }
        return templates;
    }

    private List<Template> findTemplates(Module module, String templateName, List<? extends Object> arguments) {
        ArrayList<Template> templates = new ArrayList<Template>();
        for (ModuleElement element : module.getOwnedModuleElement()) {
            Template template;
            if (!(element instanceof Template) || (template = (Template)element).getVisibility() != VisibilityKind.PUBLIC || !templateName.equals(template.getName()) || template.getParameter().size() != arguments.size()) continue;
            boolean parameterMatch = true;
            int i = 0;
            while (i < template.getParameter().size()) {
                if (!((EClassifier)((Variable)template.getParameter().get(i)).getType()).isInstance(arguments.get(i))) {
                    parameterMatch = false;
                }
                ++i;
            }
            if (!parameterMatch) continue;
            templates.add(template);
        }
        if (templates.isEmpty()) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString(UNDEFINED_TEMPLATE, templateName, module.getName()));
        }
        return templates;
    }

    public void setGenerationID(String generationID) {
        this.generationID = generationID;
    }

    public boolean hasGenerationOccurred() {
        return this.generationHasOccurred;
    }
}

