/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.datachange.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.datachange.CellKeyHandler;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowInsertEvent;

public class KeyRowInsertEvent
extends RowInsertEvent {
    private final List<Object> keys = new ArrayList<Object>();
    private final CellKeyHandler<?> keyHandler;

    public KeyRowInsertEvent(ILayer layer, int rowIndex, Object key, CellKeyHandler<?> keyHandler) {
        super(layer, rowIndex);
        this.keys.add(key);
        this.keyHandler = keyHandler;
    }

    public KeyRowInsertEvent(ILayer layer, Range rowPositionRange, Collection<Object> keys, CellKeyHandler<?> keyHandler) {
        super(layer, rowPositionRange);
        this.keys.addAll(keys);
        this.keyHandler = keyHandler;
    }

    public KeyRowInsertEvent(ILayer layer, Collection<Range> rowPositionRanges, Collection<Object> keys, CellKeyHandler<?> keyHandler) {
        super(layer, rowPositionRanges);
        this.keys.addAll(keys);
        this.keyHandler = keyHandler;
    }

    protected KeyRowInsertEvent(KeyRowInsertEvent event) {
        super(event);
        this.keys.addAll(event.keys);
        this.keyHandler = event.keyHandler;
    }

    public List<Object> getKeys() {
        return this.keys;
    }

    public CellKeyHandler<?> getKeyHandler() {
        return this.keyHandler;
    }

    @Override
    public KeyRowInsertEvent cloneEvent() {
        return new KeyRowInsertEvent(this);
    }
}

