/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.create.CreateApplicationCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.wizard.NewSystemWizardPage;
import org.eclipse.fordiac.ide.typemanagement.preferences.TypeManagementPreferencesHelper;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewSystemWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private NewSystemWizardPage page;

    public NewSystemWizard() {
        this.setWindowTitle(Messages.NewSystemWizardPage_NewSystemTitle);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(Messages.NewSystemWizardPage_NewSystemTitle);
    }

    public void addPages() {
        this.page = new NewSystemWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    IProgressMonitor monitorToUse = monitor == null ? new NullProgressMonitor() : monitor;
                    AutomationSystem system = SystemManager.INSTANCE.createNewSystem(NewSystemWizard.this.getSystemLocation(), NewSystemWizard.this.page.getSystemName(), monitorToUse);
                    TypeManagementPreferencesHelper.setupVersionInfo((LibraryElement)system, (IProject)system.getTypeLibrary().getProject());
                    NewSystemWizard.this.createInitialApplication(system);
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    private final IContainer getSystemLocation() {
        IPath targetPath = this.getTargetFile().getParent().getLocation();
        return ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(targetPath);
    }

    private final IFile getTargetFile() {
        String sysName = this.page.getSystemName();
        IWorkspaceRoot wsr = ResourcesPlugin.getWorkspace().getRoot();
        return wsr.getFile((IPath)new Path(String.valueOf(this.page.getContainerFullPath()) + File.separator + sysName));
    }

    private void createInitialApplication(AutomationSystem system) {
        CreateApplicationCommand cmd = new CreateApplicationCommand(system, this.page.getInitialApplicationName());
        cmd.execute();
        Application app = cmd.getCreatedElement();
        if (this.page.getOpenApplication() && app != null) {
            OpenListenerManager.openEditor((EObject)app);
        }
    }
}

