/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.segment.commands;

import org.eclipse.fordiac.ide.systemconfiguration.segment.communication.CommunicationFactory;
import org.eclipse.fordiac.ide.systemconfiguration.segment.communication.TsnConfiguration;
import org.eclipse.fordiac.ide.systemconfiguration.segment.communication.TsnWindow;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;

public class CreateTsnWindowCommand
extends CreationCommand {
    private final TsnConfiguration config;
    private TsnWindow newWindow;
    private final String comment;
    private final int duration;

    public CreateTsnWindowCommand(TsnConfiguration config, int duration) {
        this(config, "ChannelP", "", duration);
    }

    public CreateTsnWindowCommand(TsnConfiguration config, String name, String comment, int duration) {
        this.config = config;
        this.comment = comment;
        this.duration = duration;
    }

    public boolean canExecute() {
        return this.config != null && this.config.getWindows().size() < 8;
    }

    public void execute() {
        this.newWindow = CommunicationFactory.eINSTANCE.createTsnWindow();
        this.newWindow.setComment(this.comment);
        this.newWindow.setDuration(this.duration);
        this.config.getWindows().add((Object)this.newWindow);
    }

    public void undo() {
        this.config.getWindows().remove((Object)this.newWindow);
    }

    public void redo() {
        this.config.getWindows().add((Object)this.newWindow);
    }

    public Object getCreatedElement() {
        return this.newWindow;
    }
}

