/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.LwordType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyBitValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class LWordValue
implements AnyBitValue {
    public static final LWordValue DEFAULT = new LWordValue(0L);
    private final long value;

    private LWordValue(long value) {
        this.value = value;
    }

    public static LWordValue toLWordValue(long value) {
        return new LWordValue(value);
    }

    public static LWordValue toLWordValue(Number value) {
        return new LWordValue(value.longValue());
    }

    public static LWordValue toLWordValue(String value) {
        return LWordValue.toLWordValue((Number)NumericValueConverter.INSTANCE_LWORD.toValue(value));
    }

    public static LWordValue toLWordValue(AnyBitValue value) {
        return LWordValue.toLWordValue(value.longValue());
    }

    public LwordType getType() {
        return IecTypes.ElementaryTypes.LWORD;
    }

    @Override
    public boolean boolValue() {
        return this.value != 0L;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return new BigInteger(Long.toUnsignedString(this.value));
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LWordValue other = (LWordValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return NumericValueConverter.INSTANCE_LWORD.toString((Object)this.longValue());
    }
}

