/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteMappedCommunicationFbCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationChannel;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.commands.Command;

public class UnmapCommand
extends Command
implements ScopedCommand {
    private final Mapping mapping;
    private final AutomationSystem system;
    private int elementIndex;
    private final DeleteFBNetworkElementCommand deleteMappedFBCmd;

    public UnmapCommand(FBNetworkElement element) {
        super(FordiacMessages.Unmap);
        this.mapping = element.getMapping();
        this.system = this.mapping.getAutomationSystem();
        this.deleteMappedFBCmd = UnmapCommand.getDeleteMappedFbCommand(this.mapping.getTo());
    }

    public boolean canExecute() {
        return this.system != null;
    }

    public void execute() {
        this.mapping.getFrom().setMapping(null);
        this.mapping.getTo().setMapping(null);
        this.elementIndex = this.system.getMapping().indexOf((Object)this.mapping);
        this.system.getMapping().remove((Object)this.mapping);
        this.deleteMappedFBCmd.execute();
    }

    public void undo() {
        this.deleteMappedFBCmd.undo();
        this.mapping.getFrom().setMapping(this.mapping);
        this.mapping.getTo().setMapping(this.mapping);
        this.system.getMapping().add(this.elementIndex, (Object)this.mapping);
    }

    public void redo() {
        this.mapping.getFrom().setMapping(null);
        this.mapping.getTo().setMapping(null);
        this.system.getMapping().remove((Object)this.mapping);
        this.deleteMappedFBCmd.redo();
    }

    public FBNetworkElement getMappedFBNetworkElement() {
        return this.deleteMappedFBCmd.getFBNetworkElement();
    }

    private static DeleteFBNetworkElementCommand getDeleteMappedFbCommand(FBNetworkElement fb) {
        if (fb instanceof CommunicationChannel) {
            CommunicationChannel channel = (CommunicationChannel)fb;
            return new DeleteMappedCommunicationFbCommand(channel);
        }
        return new DeleteFBNetworkElementCommand(fb);
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.mapping.getFrom(), this.deleteMappedFBCmd.getFbParent().eContainer());
    }

    public int getElementIndex() {
        return this.elementIndex;
    }
}

