/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.AttributeInheritMode;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.gef.commands.Command;

public class ChangeInheritAttributeCommand
extends Command
implements ScopedCommand {
    private final AttributeDeclaration attributeDeclaration;
    private final AttributeInheritMode newMode;
    private final AttributeInheritMode oldMode;

    public ChangeInheritAttributeCommand(AttributeDeclaration attributeDeclaration, AttributeInheritMode inheritMode) {
        this.attributeDeclaration = attributeDeclaration;
        this.newMode = inheritMode;
        Attribute inheritAttribute = attributeDeclaration.getAttribute(InternalAttributeDeclarations.INHERIT.getName());
        this.oldMode = inheritAttribute != null ? AttributeInheritMode.valueOf((String)inheritAttribute.getValue()) : AttributeInheritMode.IGNORE;
    }

    public void execute() {
        this.changeValue(this.newMode);
    }

    public void undo() {
        this.changeValue(this.oldMode);
    }

    public void redo() {
        this.changeValue(this.newMode);
    }

    private void changeValue(AttributeInheritMode mode) {
        if (mode == AttributeInheritMode.IGNORE) {
            this.attributeDeclaration.deleteAttribute(InternalAttributeDeclarations.INHERIT.getName());
        } else {
            this.attributeDeclaration.setAttribute(InternalAttributeDeclarations.INHERIT, mode.name(), null);
        }
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.attributeDeclaration);
    }
}

