/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.edit;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.commands.change.ChangeConditionExpressionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEdit;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ConditionExpressionEdit
extends ModelEdit<ECTransition> {
    private final String newValue;
    private String oldValue;

    public ConditionExpressionEdit(String name, URI elementURI, String newValue) {
        super(name, elementURI, ECTransition.class);
        this.newValue = newValue;
    }

    @Override
    protected Command createCommand(ECTransition element) {
        return new ChangeConditionExpressionCommand(element, this.newValue);
    }

    @Override
    public void initializeValidationData(ECTransition element, IProgressMonitor pm) {
        this.oldValue = element.getConditionExpression();
    }

    @Override
    public RefactoringStatus isValid(ECTransition element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (!Objects.equals(element.getConditionExpression(), this.oldValue)) {
            status.addFatalError(Messages.ConditionExpressionEdit_ConditionExpressionChanged);
        }
        return status;
    }
}

