/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typeeditor.internal;

import java.text.MessageFormat;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.typeeditor.ITypeEditorPage;

public class TypeEditorPageDescriptor {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String SORT_INDEX_ATTRIBUTE = "sortIndex";
    private static final String LOG_MESSAGE = "{0} in extension {1} from plugin {2}";
    private final IConfigurationElement element;
    private Expression enablement;
    private int sortIndex = -1;

    public TypeEditorPageDescriptor(IConfigurationElement element) {
        this.element = element;
    }

    public boolean handlesType(LibraryElement type) {
        try {
            return this.getEnablement().evaluate((IEvaluationContext)new EvaluationContext(null, (Object)type)) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            this.log("Exception occurred evaluating enablement expression", e);
            return false;
        }
    }

    public ITypeEditorPage createEditorPage() {
        return (ITypeEditorPage)SafeRunner.run(() -> (ITypeEditorPage)this.element.createExecutableExtension(CLASS_ATTRIBUTE));
    }

    public int getSortIndex() {
        if (this.sortIndex < 0) {
            try {
                this.sortIndex = Integer.parseInt(this.element.getAttribute(SORT_INDEX_ATTRIBUTE));
                if (this.sortIndex < 0) {
                    this.sortIndex = 0;
                }
            }
            catch (NumberFormatException e) {
                this.log("Invalid sortIndex attribute", e);
                this.sortIndex = Integer.MAX_VALUE;
            }
        }
        return this.sortIndex;
    }

    private Expression getEnablement() {
        if (this.enablement == null) {
            this.enablement = this.createEnablement();
        }
        return this.enablement;
    }

    private Expression createEnablement() {
        IConfigurationElement[] children = this.element.getChildren("enablement");
        if (children.length == 0) {
            return Expression.TRUE;
        }
        if (children.length > 1) {
            this.log("More than one enablement sub-element");
            return Expression.FALSE;
        }
        try {
            return ExpressionConverter.getDefault().perform(children[0]);
        }
        catch (CoreException e) {
            this.log("Invalid enablement expression", e);
            return Expression.FALSE;
        }
    }

    private void log(String message) {
        Platform.getLog(this.getClass()).error(MessageFormat.format(LOG_MESSAGE, message, this.element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), this.element.getDeclaringExtension().getContributor().getName()));
    }

    private void log(String message, Throwable t) {
        Platform.getLog(this.getClass()).error(String.format(LOG_MESSAGE, message, this.element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), this.element.getDeclaringExtension().getContributor().getName()), t);
    }
}

