/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.about.AboutItem;
import org.eclipse.ui.internal.about.AboutUtils;

public class AboutTextManager {
    private StyledText styledText;
    private boolean mouseDown = false;
    private boolean dragEvent = false;
    private AboutItem item;

    public static AboutItem scan(String aboutText) {
        ArrayList<int[]> linkRanges = new ArrayList<int[]>();
        ArrayList<String> links = new ArrayList<String>();
        int urlSeparatorOffset = aboutText.indexOf("://");
        while (urlSeparatorOffset >= 0) {
            char ch;
            boolean startDoubleQuote = false;
            int urlOffset = urlSeparatorOffset;
            do {
                ch = ' ';
                if (--urlOffset > -1) {
                    ch = aboutText.charAt(urlOffset);
                }
                boolean bl = startDoubleQuote = ch == '\"';
            } while (Character.isUnicodeIdentifierStart(ch));
            ++urlOffset;
            StringTokenizer tokenizer = new StringTokenizer(aboutText.substring(urlSeparatorOffset + 3), " \t\n\r\f<>", false);
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            int urlLength = tokenizer.nextToken().length() + 3 + urlSeparatorOffset - urlOffset;
            if (startDoubleQuote) {
                int endOffset = -1;
                int nextDoubleQuote = aboutText.indexOf(34, urlOffset);
                int nextWhitespace = aboutText.indexOf(32, urlOffset);
                if (nextDoubleQuote != -1 && nextWhitespace != -1) {
                    endOffset = Math.min(nextDoubleQuote, nextWhitespace);
                } else if (nextDoubleQuote != -1) {
                    endOffset = nextDoubleQuote;
                } else if (nextWhitespace != -1) {
                    endOffset = nextWhitespace;
                }
                if (endOffset != -1) {
                    urlLength = endOffset - urlOffset;
                }
            }
            linkRanges.add(new int[]{urlOffset, urlLength});
            links.add(aboutText.substring(urlOffset, urlOffset + urlLength));
            urlSeparatorOffset = aboutText.indexOf("://", urlOffset + urlLength + 1);
        }
        return new AboutItem(aboutText, (int[][])linkRanges.toArray((T[])new int[linkRanges.size()][2]), links.toArray(new String[links.size()]));
    }

    public AboutTextManager(StyledText text) {
        this.styledText = text;
        this.addListeners();
    }

    protected void addListeners() {
        final Cursor handCursor = this.styledText.getDisplay().getSystemCursor(21);
        final Cursor busyCursor = this.styledText.getDisplay().getSystemCursor(1);
        this.styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                AboutTextManager.this.mouseDown = true;
            }

            public void mouseUp(MouseEvent e) {
                AboutTextManager.this.mouseDown = false;
                int offset = AboutTextManager.this.styledText.getCaretOffset();
                if (AboutTextManager.this.dragEvent) {
                    AboutTextManager.this.dragEvent = false;
                    if (AboutTextManager.this.item != null && AboutTextManager.this.item.isLinkAt(offset)) {
                        AboutTextManager.this.styledText.setCursor(handCursor);
                    }
                } else if (AboutTextManager.this.item != null && AboutTextManager.this.item.isLinkAt(offset)) {
                    AboutTextManager.this.styledText.setCursor(busyCursor);
                    AboutUtils.openLink(AboutTextManager.this.styledText.getShell(), AboutTextManager.this.item.getLinkAt(offset));
                    StyleRange selectionRange = AboutTextManager.this.getCurrentRange();
                    AboutTextManager.this.styledText.setSelectionRange(selectionRange.start, selectionRange.length);
                    AboutTextManager.this.styledText.setCursor(null);
                }
            }
        });
        this.styledText.addMouseMoveListener(e -> {
            if (this.mouseDown) {
                if (!this.dragEvent) {
                    StyledText text1 = (StyledText)e.widget;
                    text1.setCursor(null);
                }
                this.dragEvent = true;
                return;
            }
            StyledText text2 = (StyledText)e.widget;
            int offset = text2.getOffsetAtPoint(new Point(e.x, e.y));
            if (offset == -1) {
                text2.setCursor(null);
            } else if (this.item != null && this.item.isLinkAt(offset)) {
                text2.setCursor(handCursor);
            } else {
                text2.setCursor(null);
            }
        });
        this.styledText.addTraverseListener(e -> {
            switch (e.detail) {
                case 2: {
                    e.doit = true;
                    break;
                }
                case 16: {
                    StyleRange nextRange;
                    Point nextSelection = this.styledText.getSelection();
                    int charCount = this.styledText.getCharCount();
                    if (nextSelection.x == charCount && nextSelection.y == charCount) {
                        this.styledText.setSelection(0);
                    }
                    if ((nextRange = this.findNextRange()) == null) {
                        this.styledText.setSelection(0);
                        e.doit = true;
                        break;
                    }
                    this.styledText.setSelectionRange(nextRange.start, nextRange.length);
                    e.doit = true;
                    e.detail = 0;
                    break;
                }
                case 8: {
                    StyleRange previousRange;
                    Point previousSelection = this.styledText.getSelection();
                    if (previousSelection.x == 0 && previousSelection.y == 0) {
                        this.styledText.setSelection(this.styledText.getCharCount());
                    }
                    if ((previousRange = this.findPreviousRange()) == null) {
                        this.styledText.setSelection(this.styledText.getCharCount());
                        e.doit = true;
                        break;
                    }
                    this.styledText.setSelectionRange(previousRange.start, previousRange.length);
                    e.doit = true;
                    e.detail = 0;
                    break;
                }
            }
        });
        this.styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                StyledText text = (StyledText)event.widget;
                if (event.character == ' ' || event.character == '\r') {
                    int offset;
                    if (AboutTextManager.this.item != null && AboutTextManager.this.item.isLinkAt(offset = text.getSelection().x + 1)) {
                        text.setCursor(busyCursor);
                        AboutUtils.openLink(AboutTextManager.this.styledText.getShell(), AboutTextManager.this.item.getLinkAt(offset));
                        StyleRange selectionRange = AboutTextManager.this.getCurrentRange();
                        text.setSelectionRange(selectionRange.start, selectionRange.length);
                        text.setCursor(null);
                    }
                    return;
                }
            }
        });
    }

    public AboutItem getItem() {
        return this.item;
    }

    public void setItem(AboutItem item) {
        this.item = item;
        if (item != null) {
            this.styledText.setText(item.getText());
            this.setLinkRanges(item.getLinkRanges());
        }
    }

    private StyleRange getCurrentRange() {
        StyleRange[] ranges = this.styledText.getStyleRanges();
        int currentSelectionEnd = this.styledText.getSelection().y;
        int currentSelectionStart = this.styledText.getSelection().x;
        StyleRange[] styleRangeArray = ranges;
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange range = styleRangeArray[n2];
            if (currentSelectionStart >= range.start && currentSelectionEnd <= range.start + range.length) {
                return range;
            }
            ++n2;
        }
        return null;
    }

    private StyleRange findNextRange() {
        StyleRange[] ranges = this.styledText.getStyleRanges();
        int currentSelectionEnd = this.styledText.getSelection().y;
        StyleRange[] styleRangeArray = ranges;
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange range = styleRangeArray[n2];
            if (range.start >= currentSelectionEnd) {
                return range;
            }
            ++n2;
        }
        return null;
    }

    private StyleRange findPreviousRange() {
        StyleRange[] ranges = this.styledText.getStyleRanges();
        int currentSelectionStart = this.styledText.getSelection().x;
        int i = ranges.length - 1;
        while (i > -1) {
            if (ranges[i].start + ranges[i].length - 1 < currentSelectionStart) {
                return ranges[i];
            }
            --i;
        }
        return null;
    }

    private void setLinkRanges(int[][] linkRanges) {
        Color fg = JFaceColors.getHyperlinkText((Display)this.styledText.getShell().getDisplay());
        int[][] nArray = linkRanges;
        int n = linkRanges.length;
        int n2 = 0;
        while (n2 < n) {
            int[] linkRange = nArray[n2];
            StyleRange r = new StyleRange(linkRange[0], linkRange[1], fg, null);
            this.styledText.setStyleRange(r);
            ++n2;
        }
    }
}

