/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.validation.description.constraints;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.business.api.dialect.description.MultiLanguagesValidator;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.internal.interpreter.SiriusInterpreterContextFactory;
import org.eclipse.sirius.tools.internal.validation.AbstractConstraint;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.tool.impl.CreateInstanceImpl;

public class ValidFeatureNameConstraint
extends AbstractConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject target = ctx.getTarget();
        LinkedHashSet<IStatus> statuses = new LinkedHashSet<IStatus>();
        for (EAttribute feature : target.eClass().getEAllAttributes()) {
            IStatus status;
            if (!DescriptionPackage.eINSTANCE.getFeatureName().equals(feature.getEAttributeType()) || (status = this.checkExpression(ctx, target, (EStructuralFeature)feature)) == null) continue;
            statuses.add(status);
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        IStatus returnStatus = statuses.size() == 1 ? (IStatus)statuses.iterator().next() : ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
        return returnStatus;
    }

    private IStatus checkExpression(IValidationContext ctx, EObject target, EStructuralFeature feature) {
        IStatus returnStatus = ctx.createSuccessStatus();
        String expression = (String)target.eGet(feature);
        IInterpreterContext context = SiriusInterpreterContextFactory.createInterpreterContext(target, feature);
        VariableType variableType = context.getTargetType();
        if (!StringUtil.isEmpty((String)expression)) {
            if (this.isTypeIdentified(variableType)) {
                Optional<EStructuralFeature> optional = variableType.getPossibleTypes().stream().flatMap(type -> type.search(context.getAvailableEPackages()).stream()).filter(EClass.class::isInstance).map(EClass.class::cast).flatMap(eClass -> eClass.getEAllStructuralFeatures().stream()).filter(f -> f.getName().equals(expression)).findFirst();
                if (!optional.isPresent()) {
                    returnStatus = ctx.createFailureStatus(new Object[]{expression, variableType});
                } else if (target instanceof CreateInstanceImpl) {
                    EClassifier eType = optional.get().getEType();
                    VariableType refType = VariableType.fromEClassifiers((Collection)Sets.newLinkedHashSet(Arrays.asList(eType)));
                    returnStatus = this.checkFeatureWithType(ctx, target, feature, refType);
                }
            }
        } else {
            returnStatus = ctx.createFailureStatus(new Object[]{expression, variableType});
        }
        return returnStatus;
    }

    private IStatus checkFeatureWithType(IValidationContext ctx, EObject target, EStructuralFeature feature, VariableType variableType) {
        IInterpreterContext context = SiriusInterpreterContextFactory.createInterpreterContext(target, feature);
        for (EAttribute feat : Iterables.filter((Iterable)target.eClass().getEAllStructuralFeatures(), EAttribute.class)) {
            TypeName className;
            Object value;
            if (DescriptionPackage.Literals.TYPE_NAME != feat.getEType() || !((value = target.eGet((EStructuralFeature)feat)) instanceof String) || !(className = TypeName.fromString((String)((String)value))).getPackagePrefix().isPresent()) continue;
            String expression = (String)target.eGet(feature);
            context.getVariables().put("toCheck", variableType);
            for (IInterpreterStatus s : MultiLanguagesValidator.getInstance().validateExpression(context, "aql:toCheck.oclIsKindOf(" + className.getCompleteName("::") + ")").getStatuses()) {
                if (!s.getMessage().contains("Always false")) continue;
                return ctx.createFailureStatus(new Object[]{expression, className.getCompleteName("::")});
            }
        }
        return ctx.createSuccessStatus();
    }

    private boolean isTypeIdentified(VariableType variableType) {
        return variableType.hasDefinition() && variableType.getPossibleTypes().stream().anyMatch(tn -> !TypeName.EOBJECT_TYPENAME.equals(tn));
    }
}

