/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.editor;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.config.NatTableConfigAttributes;
import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.data.validate.ValidationFailedException;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.layer.IDpiConverter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleProxy;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.PlatformHelper;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TableCellEditor
extends AbstractCellEditor {
    private TableViewer viewer;
    private final boolean moveSelectionOnEnter;
    private final boolean alwaysOpenEditor;
    private int fixedSubCellHeight;
    private InternalLabelProvider labelProvider;
    protected ICellEditorValidator cellEditorValidator = value -> {
        if (this.displayConverter != null) {
            Object cValue = null;
            try {
                cValue = this.displayConverter.displayToCanonicalValue(this.layerCell, this.configRegistry, value);
                if (!this.validateCanonicalValue(cValue)) {
                    return Messages.getString("AbstractCellEditor.validationFailure");
                }
            }
            catch (ConversionFailedException | ValidationFailedException e) {
                return e.getLocalizedMessage();
            }
        }
        return null;
    };

    public TableCellEditor() {
        this(20, true, true);
    }

    public TableCellEditor(int fixedSubCellHeight, boolean moveSelectionOnEnter, boolean alwaysOpenEditor) {
        this.fixedSubCellHeight = fixedSubCellHeight;
        this.moveSelectionOnEnter = moveSelectionOnEnter;
        this.alwaysOpenEditor = alwaysOpenEditor;
        this.focusListener = new InternalFocusListener();
    }

    @Override
    public Object getEditorValue() {
        return this.viewer.getInput();
    }

    @Override
    public void setEditorValue(Object value) {
        if (value != null && value.getClass().isArray()) {
            this.viewer.setInput(value);
        }
    }

    @Override
    public Object getCanonicalValue() {
        Object[] editorValues = this.getDataAsArray(this.getEditorValue());
        Object[] dataValues = new Object[editorValues.length];
        int i = 0;
        while (i < editorValues.length) {
            Object value = editorValues[i];
            Object canonicalValue = this.displayConverter != null ? this.displayConverter.displayToCanonicalValue(this.layerCell, this.configRegistry, value) : value;
            dataValues[i] = canonicalValue;
            ++i;
        }
        if (this.layerCell.getDataValue().getClass().isArray()) {
            Object[] originalDataArray = (Object[])this.layerCell.getDataValue();
            Object[] cellDataArray = (Object[])originalDataArray.clone();
            int i2 = 0;
            while (i2 < cellDataArray.length) {
                cellDataArray[i2] = dataValues[i2];
                ++i2;
            }
            return cellDataArray;
        }
        if (this.layerCell.getDataValue() instanceof Collection) {
            Collection originalDataCollection;
            Collection cellDataCollection = originalDataCollection = (Collection)this.layerCell.getDataValue();
            if (originalDataCollection instanceof Cloneable) {
                try {
                    Method cloneMethod = originalDataCollection.getClass().getMethod("clone", new Class[0]);
                    cellDataCollection = (Collection)cloneMethod.invoke((Object)originalDataCollection, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            cellDataCollection.clear();
            cellDataCollection.addAll(Arrays.asList(dataValues));
            return cellDataCollection;
        }
        return this.layerCell.getDataValue();
    }

    @Override
    public void setCanonicalValue(Object canonicalValue) {
        Object[] values = this.getDataAsArray(canonicalValue);
        if (values != null) {
            ValueWrapper[] editorValues = new ValueWrapper[values.length];
            int i = 0;
            while (i < values.length) {
                Object value = values[i];
                Object displayValue = this.displayConverter != null ? this.displayConverter.canonicalToDisplayValue(this.layerCell, this.configRegistry, value) : value;
                editorValues[i] = new ValueWrapper(String.valueOf(displayValue));
                ++i;
            }
            this.setEditorValue(editorValues);
        }
    }

    public Table getEditorControl() {
        return this.viewer.getTable();
    }

    public Table createEditorControl(Composite parent) {
        this.viewer = new TableViewer(parent, 65536);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn emptyColumn = new TableViewerColumn(this.viewer, 0);
        emptyColumn.getColumn().setWidth(0);
        emptyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }
        });
        TableViewerColumn singleColumn = new TableViewerColumn(this.viewer, 0);
        singleColumn.getColumn().setAlignment(HorizontalAlignmentEnum.getSWTStyle(this.cellStyle));
        singleColumn.setLabelProvider((CellLabelProvider)this.labelProvider);
        singleColumn.setEditingSupport(this.getEditingSupport());
        final Table tableControl = this.viewer.getTable();
        tableControl.setBackground(this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        tableControl.setLinesVisible(true);
        if (this.getFixedSubCellHeight() >= 0) {
            IDpiConverter dpiConverter = this.configRegistry.getConfigAttribute(NatTableConfigAttributes.HORIZONTAL_DPI_CONVERTER, DisplayMode.NORMAL, new String[0]);
            int height = dpiConverter != null ? (int)(dpiConverter.getCurrentDpiFactor() * (float)this.getFixedSubCellHeight()) : this.getFixedSubCellHeight();
            tableControl.addListener(41, event -> {
                int n2 = event.height = height + 1;
            });
        }
        tableControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 27 && event.stateMask == 0) {
                    TableCellEditor.this.close();
                }
                if (event.keyCode == 0x100000B) {
                    Object element = ((StructuredSelection)TableCellEditor.this.viewer.getSelection()).getFirstElement();
                    if (element == null) {
                        tableControl.setSelection(tableControl.getTopIndex());
                        element = ((StructuredSelection)TableCellEditor.this.viewer.getSelection()).getFirstElement();
                    }
                    if (element != null) {
                        TableCellEditor.this.viewer.editElement(element, 1);
                    }
                }
            }
        });
        tableControl.addListener(11, event -> {
            tableControl.getColumn(1).setWidth(table.getClientArea().width);
            Point mouseLoc = Display.getCurrent().getCursorLocation();
            Point tablePos = tableControl.toDisplay(0, 0);
            int relativeX = mouseLoc.x - tablePos.x;
            int relativeY = mouseLoc.y - tablePos.y;
            TableItem item = tableControl.getItem(new Point(relativeX, relativeY));
            if (item != null) {
                tableControl.setSelection(item);
            } else {
                tableControl.setSelection(tableControl.getTopIndex());
            }
            if (tableControl.getItemCount() > 0) {
                this.viewer.editElement(((StructuredSelection)this.viewer.getSelection()).getFirstElement(), 1);
            }
        });
        return tableControl;
    }

    @Override
    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        this.labelProvider = new InternalLabelProvider();
        this.createEditorControl(parent);
        this.setCanonicalValue(originalCanonicalValue);
        this.getEditorControl().forceFocus();
        return this.getEditorControl();
    }

    @Override
    public void close() {
        this.viewer.applyEditorValue();
        super.close();
    }

    @Override
    public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit, boolean skipValidation) {
        this.viewer.applyEditorValue();
        return super.commit(direction, closeAfterCommit, skipValidation);
    }

    protected Object[] getDataAsArray(Object cellData) {
        Object[] cellDataArray = null;
        if (cellData != null) {
            if (cellData.getClass().isArray()) {
                cellDataArray = (Object[])cellData;
            } else if (cellData instanceof Collection) {
                Collection cellDataCollection = (Collection)cellData;
                cellDataArray = cellDataCollection.toArray();
            }
        }
        return cellDataArray;
    }

    public int getFixedSubCellHeight() {
        if (PlatformHelper.isRAP()) {
            return -1;
        }
        return this.fixedSubCellHeight;
    }

    public void setFixedSubCellHeight(int fixedSubCellHeight) {
        this.fixedSubCellHeight = fixedSubCellHeight;
    }

    protected EditingSupport getEditingSupport() {
        return new TableCellEditingSupport();
    }

    @Override
    public void addEditorControlListeners() {
        Table editorControl = this.getEditorControl();
        if (editorControl != null && !editorControl.isDisposed() && this.editMode == EditModeEnum.INLINE) {
            editorControl.addTraverseListener(this.traverseListener);
            editorControl.addFocusListener(this.focusListener);
        }
    }

    @Override
    public void removeEditorControlListeners() {
        Table editorControl = this.getEditorControl();
        if (editorControl != null && !editorControl.isDisposed()) {
            editorControl.removeTraverseListener(this.traverseListener);
            editorControl.removeFocusListener(this.focusListener);
        }
    }

    protected class InternalFocusListener
    implements FocusListener {
        boolean hasFocus = false;

        protected InternalFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            this.hasFocus = false;
            Display.getCurrent().timerExec(100, () -> {
                if (!this.hasFocus && !TableCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE, true) && focusEvent.widget instanceof Control && !focusEvent.widget.isDisposed()) {
                    ((Control)focusEvent.widget).forceFocus();
                }
            });
        }

        public void focusGained(FocusEvent e) {
            this.hasFocus = true;
        }
    }

    protected class InternalLabelProvider
    extends ColumnLabelProvider {
        private IStyle normalStyle;
        private IStyle conversionErrorStyle;
        private IStyle validationErrorStyle;

        public InternalLabelProvider() {
            this.normalStyle = TableCellEditor.this.cellStyle;
            this.conversionErrorStyle = TableCellEditor.this.configRegistry.getConfigAttribute(EditConfigAttributes.CONVERSION_ERROR_STYLE, DisplayMode.EDIT, (List<String>)TableCellEditor.this.labelStack);
            if (this.conversionErrorStyle == null) {
                this.conversionErrorStyle = new Style();
                this.conversionErrorStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, GUIHelper.COLOR_RED);
            }
            this.validationErrorStyle = TableCellEditor.this.configRegistry.getConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_STYLE, DisplayMode.EDIT, (List<String>)TableCellEditor.this.labelStack);
            if (this.validationErrorStyle == null) {
                this.validationErrorStyle = new Style();
                this.validationErrorStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, GUIHelper.COLOR_RED);
            }
        }

        public IStyle getActiveCellStyle(Object element) {
            if (!((ValueWrapper)element).isValid()) {
                return this.validationErrorStyle;
            }
            return this.normalStyle;
        }

        public void applyCellStyle(Control editorControl, Object element) {
            Font font;
            Color background;
            Color foreground = this.getForeground(element);
            if (foreground != null) {
                editorControl.setForeground(foreground);
            }
            if ((background = this.getBackground(element)) != null) {
                editorControl.setBackground(this.getBackground(element));
            }
            if ((font = this.getFont(element)) != null) {
                editorControl.setFont(font);
            }
            editorControl.setOrientation(HorizontalAlignmentEnum.getSWTStyle(this.getActiveCellStyle(element)));
        }

        public Color getForeground(Object element) {
            return this.getActiveCellStyle(element).getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        }

        public Color getBackground(Object element) {
            return this.getActiveCellStyle(element).getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        }

        public Font getFont(Object element) {
            if (TableCellEditor.this.getFixedSubCellHeight() >= 0) {
                IStyle style = this.getActiveCellStyle(element);
                if (style instanceof CellStyleProxy) {
                    return style.getAttributeValue(CellStyleAttributes.FONT);
                }
                return CellStyleUtil.getFont(style, TableCellEditor.this.configRegistry);
            }
            return null;
        }
    }

    protected class TableCellEditingSupport
    extends EditingSupport {
        private CellEditor editor;

        public TableCellEditingSupport() {
            super((ColumnViewer)TableCellEditor.this.viewer);
            int style = 4 | HorizontalAlignmentEnum.getSWTStyle(TableCellEditor.this.cellStyle);
            this.editor = new TextCellEditor((Composite)TableCellEditor.this.viewer.getTable(), style);
        }

        protected CellEditor getCellEditor(final Object element) {
            int style = 4 | HorizontalAlignmentEnum.getSWTStyle(TableCellEditor.this.cellStyle);
            this.editor = new TextCellEditor((Composite)TableCellEditor.this.viewer.getTable(), style);
            this.editor.setValidator(TableCellEditor.this.cellEditorValidator);
            this.editor.addListener(new ICellEditorListener(){

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    ((ValueWrapper)element).setValid(TableCellEditingSupport.this.editor.isValueValid());
                    ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.labelProvider.applyCellStyle(TableCellEditingSupport.this.editor.getControl(), element);
                }

                public void cancelEditor() {
                    if (((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.editMode == EditModeEnum.INLINE) {
                        TableCellEditor.this.close();
                    }
                }

                public void applyEditorValue() {
                }
            });
            this.editor.getControl().addTraverseListener(event -> {
                if (event.keyCode == 9) {
                    this.setValue(element, ((Text)this.editor.getControl()).getText());
                    boolean committed = false;
                    if (event.stateMask == SWT.MOD2) {
                        committed = TableCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.LEFT);
                    } else if (event.stateMask == 0) {
                        committed = TableCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.RIGHT);
                    }
                    if (!committed) {
                        event.doit = false;
                    }
                }
            });
            this.editor.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                        TableCellEditingSupport.this.setValue(element, ((Text)TableCellEditingSupport.this.editor.getControl()).getText());
                        if (TableCellEditingSupport.this.editor.isValueValid()) {
                            int selectionIndex = ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().getSelectionIndex();
                            if (((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.moveSelectionOnEnter && selectionIndex + 1 < ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().getItemCount()) {
                                ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().setSelection(++selectionIndex);
                                if (((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.alwaysOpenEditor) {
                                    ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.editElement(((StructuredSelection)((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getSelection()).getFirstElement(), 1);
                                }
                            } else {
                                TableCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE, ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.editMode == EditModeEnum.INLINE);
                            }
                        } else {
                            ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.editElement(((StructuredSelection)((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getSelection()).getFirstElement(), 1);
                        }
                    } else if (event.keyCode == 0x1000002) {
                        TableCellEditingSupport.this.setValue(element, ((Text)TableCellEditingSupport.this.editor.getControl()).getText());
                        int selectionIndex = ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().getSelectionIndex();
                        if (selectionIndex + 1 < ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().getItemCount()) {
                            ++selectionIndex;
                        }
                        ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().setSelection(selectionIndex);
                        if (((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.alwaysOpenEditor) {
                            ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.editElement(((StructuredSelection)((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getSelection()).getFirstElement(), 1);
                        }
                    } else if (event.keyCode == 0x1000001) {
                        TableCellEditingSupport.this.setValue(element, ((Text)TableCellEditingSupport.this.editor.getControl()).getText());
                        int selectionIndex = ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().getSelectionIndex();
                        if (selectionIndex > 0) {
                            --selectionIndex;
                        }
                        ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().setSelection(selectionIndex);
                        if (((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.alwaysOpenEditor) {
                            ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.editElement(((StructuredSelection)((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getSelection()).getFirstElement(), 1);
                        }
                    }
                }
            });
            if (TableCellEditor.this.editMode == EditModeEnum.INLINE) {
                this.editor.getControl().addFocusListener(TableCellEditor.this.focusListener);
            }
            TableCellEditor.this.labelProvider.applyCellStyle(this.editor.getControl(), element);
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((ValueWrapper)element).getValue();
        }

        protected void setValue(Object element, Object value) {
            if (this.editor.isValueValid()) {
                ((ValueWrapper)element).setValue(value);
                ((ValueWrapper)element).setValid(true);
            } else {
                ((ValueWrapper)element).setValid(false);
            }
            TableCellEditor.this.viewer.refresh();
        }
    }

    protected class ValueWrapper {
        private Object value;
        private boolean valid = true;

        protected ValueWrapper(Object value) {
            this.setValue(value);
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
            this.valid = TableCellEditor.this.cellEditorValidator.isValid(value) == null;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public String toString() {
            return this.value != null ? this.value.toString() : "";
        }
    }
}

