/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.AuditHistoryUpdateEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.AuditHistoryEventUpdateEventType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.PerformUpdateType;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryEventFieldList;

public class AuditHistoryEventUpdateEventTypeNode
extends AuditHistoryUpdateEventTypeNode
implements AuditHistoryEventUpdateEventType {
    public AuditHistoryEventUpdateEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public NodeId getUpdatedNode() throws UaException {
        PropertyTypeNode node = this.getUpdatedNodeNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setUpdatedNode(NodeId updatedNode) throws UaException {
        PropertyTypeNode node = this.getUpdatedNodeNode();
        node.setValue(new Variant((Object)updatedNode));
    }

    @Override
    public NodeId readUpdatedNode() throws UaException {
        try {
            return this.readUpdatedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeUpdatedNode(NodeId updatedNode) throws UaException {
        try {
            this.writeUpdatedNodeAsync(updatedNode).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readUpdatedNodeAsync() {
        return ((CompletableFuture)this.getUpdatedNodeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeUpdatedNodeAsync(NodeId updatedNode) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)updatedNode));
        return this.getUpdatedNodeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getUpdatedNodeNode() throws UaException {
        try {
            return this.getUpdatedNodeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUpdatedNodeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UpdatedNode", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public PerformUpdateType getPerformInsertReplace() throws UaException {
        PropertyTypeNode node = this.getPerformInsertReplaceNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return PerformUpdateType.from((int)((Integer)value));
        }
        if (value instanceof PerformUpdateType) {
            return (PerformUpdateType)value;
        }
        return null;
    }

    @Override
    public void setPerformInsertReplace(PerformUpdateType performInsertReplace) throws UaException {
        PropertyTypeNode node = this.getPerformInsertReplaceNode();
        node.setValue(new Variant((Object)performInsertReplace));
    }

    @Override
    public PerformUpdateType readPerformInsertReplace() throws UaException {
        try {
            return this.readPerformInsertReplaceAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePerformInsertReplace(PerformUpdateType performInsertReplace) throws UaException {
        try {
            this.writePerformInsertReplaceAsync(performInsertReplace).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends PerformUpdateType> readPerformInsertReplaceAsync() {
        return ((CompletableFuture)this.getPerformInsertReplaceNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return PerformUpdateType.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writePerformInsertReplaceAsync(PerformUpdateType performInsertReplace) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)performInsertReplace));
        return this.getPerformInsertReplaceNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPerformInsertReplaceNode() throws UaException {
        try {
            return this.getPerformInsertReplaceNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPerformInsertReplaceNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PerformInsertReplace", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public EventFilter getFilter() throws UaException {
        PropertyTypeNode node = this.getFilterNode();
        return this.cast(node.getValue().getValue().getValue(), EventFilter.class);
    }

    @Override
    public void setFilter(EventFilter filter) throws UaException {
        PropertyTypeNode node = this.getFilterNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)filter);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public EventFilter readFilter() throws UaException {
        try {
            return this.readFilterAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeFilter(EventFilter filter) throws UaException {
        try {
            this.writeFilterAsync(filter).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends EventFilter> readFilterAsync() {
        return ((CompletableFuture)this.getFilterNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), EventFilter.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeFilterAsync(EventFilter filter) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)filter);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getFilterNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getFilterNode() throws UaException {
        try {
            return this.getFilterNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getFilterNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Filter", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public HistoryEventFieldList[] getNewValues() throws UaException {
        PropertyTypeNode node = this.getNewValuesNode();
        return this.cast(node.getValue().getValue().getValue(), HistoryEventFieldList[].class);
    }

    @Override
    public void setNewValues(HistoryEventFieldList[] newValues) throws UaException {
        PropertyTypeNode node = this.getNewValuesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure[])newValues);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public HistoryEventFieldList[] readNewValues() throws UaException {
        try {
            return this.readNewValuesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNewValues(HistoryEventFieldList[] newValues) throws UaException {
        try {
            this.writeNewValuesAsync(newValues).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends HistoryEventFieldList[]> readNewValuesAsync() {
        return ((CompletableFuture)this.getNewValuesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), HistoryEventFieldList[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeNewValuesAsync(HistoryEventFieldList[] newValues) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure[])newValues);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getNewValuesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNewValuesNode() throws UaException {
        try {
            return this.getNewValuesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNewValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NewValues", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public HistoryEventFieldList[] getOldValues() throws UaException {
        PropertyTypeNode node = this.getOldValuesNode();
        return this.cast(node.getValue().getValue().getValue(), HistoryEventFieldList[].class);
    }

    @Override
    public void setOldValues(HistoryEventFieldList[] oldValues) throws UaException {
        PropertyTypeNode node = this.getOldValuesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure[])oldValues);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public HistoryEventFieldList[] readOldValues() throws UaException {
        try {
            return this.readOldValuesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeOldValues(HistoryEventFieldList[] oldValues) throws UaException {
        try {
            this.writeOldValuesAsync(oldValues).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends HistoryEventFieldList[]> readOldValuesAsync() {
        return ((CompletableFuture)this.getOldValuesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), HistoryEventFieldList[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeOldValuesAsync(HistoryEventFieldList[] oldValues) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure[])oldValues);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getOldValuesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getOldValuesNode() throws UaException {
        try {
            return this.getOldValuesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getOldValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OldValues", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

