/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.model.helpers.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerRef;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.ui.Activator;
import org.eclipse.fordiac.ide.model.ui.editors.BreadcrumbNavigationLocation;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.model.ui.widgets.BreadcrumbWidget;
import org.eclipse.fordiac.ide.ui.editors.AbstractCloseAbleFormEditor;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public abstract class AbstractBreadCrumbEditor
extends AbstractCloseAbleFormEditor
implements CommandStackEventListener,
ITabbedPropertySheetPageContributor,
IGotoMarker,
INavigationLocationProvider,
IPersistableEditor {
    private static final String TAG_BREADCRUMB_HIERACHY = "FORDIAC_BREADCRUMB_HIERACHY";
    private static final String TAG_GRAPHICAL_VIEWER_ZOOM = "FORDIAC_GRAPHICAL_VIEWER_ZOOM";
    private static final String TAG_GRAPHICAL_VIEWER_HOR_SCROLL = "FORDIAC_GRAPHICAL_VIEWER_HOR_SCROLL";
    private static final String TAG_GRAPHICAL_VIEWER_VER_SCROLL = "FORDIAC_GRAPHICAL_VIEWER_VER_SCROLL";
    private Map<Object, Integer> modelToEditorNum = new HashMap<Object, Integer>();
    private BreadcrumbWidget breadcrumb;
    private IMemento memento;

    public BreadcrumbWidget getBreadcrumb() {
        return this.breadcrumb;
    }

    protected Map<Object, Integer> getModelToEditorNumMapping() {
        return this.modelToEditorNum;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)GridLayoutFactory.fillDefaults().equalWidth(true).spacing(0, 0).create());
        this.breadcrumb = new BreadcrumbWidget(parent);
        super.createPartControl(parent);
        ((CTabFolder)this.getContainer()).setTabHeight(0);
        this.initializeBreadcrumb();
        String itemPath = null;
        if (this.memento != null) {
            itemPath = this.memento.getString(TAG_BREADCRUMB_HIERACHY);
        }
        this.setInitialModel(this.getInitialModel(itemPath));
        this.memento = null;
        this.breadcrumb.addSelectionChangedListener(event -> this.handleBreadCrumbSelection(((StructuredSelection)event.getSelection()).getFirstElement()));
    }

    private void initializeBreadcrumb() {
        this.getBreadcrumb().setContentProvider(this.createBreadcrumbContentProvider());
        this.getBreadcrumb().setLabelProvider(this.createBreadcrumbLabelProvider());
    }

    protected void setInitialModel(Object model) {
        this.getBreadcrumb().setInput(model);
        int pagenum = this.modelToEditorNum.computeIfAbsent(model, this::createEditor);
        if (-1 != pagenum) {
            this.setActivePage(pagenum);
            GraphicalViewer viewer = (GraphicalViewer)this.getEditor(pagenum).getAdapter(GraphicalViewer.class);
            if (viewer != null && this.memento != null) {
                AbstractBreadCrumbEditor.restoreGraphicalViewerState(viewer, this.memento);
            }
        }
    }

    protected Composite createPageContainer(Composite parent) {
        Composite pageContainer = new Composite(parent, 0);
        pageContainer.setLayoutData((Object)new GridData(1808));
        return pageContainer;
    }

    protected void handleBreadCrumbSelection(Object element) {
        int pagenum = this.modelToEditorNum.computeIfAbsent(element, this::createEditor);
        if (-1 != pagenum) {
            this.setActivePage(pagenum);
            this.getSite().getPage().getNavigationHistory().markLocation(this.getNavigationLocationProvider());
        }
    }

    protected IEditorPart getNavigationLocationProvider() {
        if (this.getSite().getPart() instanceof IEditorPart) {
            return (IEditorPart)this.getSite().getPart();
        }
        return this;
    }

    private int createEditor(Object model) {
        EditorPart part = this.createEditorPart(model);
        if (part != null) {
            IEditorInput input = this.createEditorInput(model);
            try {
                return this.addPage((IEditorPart)part, input);
            }
            catch (PartInitException e) {
                Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
            }
        }
        return -1;
    }

    public boolean closeChildEditor(IEditorPart childEditor) {
        int pageIndex = this.pages.indexOf(childEditor);
        if (pageIndex != -1) {
            this.removePage(pageIndex);
            this.updateEditorMapping(pageIndex);
            return true;
        }
        return false;
    }

    private void updateEditorMapping(int pageIndex) {
        HashMap<Object, Integer> newModelToEditorNum = new HashMap<Object, Integer>();
        this.modelToEditorNum.forEach((obj, index) -> {
            int intIndex = index;
            if (intIndex != pageIndex) {
                if (intIndex < pageIndex) {
                    newModelToEditorNum.put(obj, intIndex);
                } else {
                    newModelToEditorNum.put(obj, intIndex - 1);
                }
            }
        });
        this.modelToEditorNum = newModelToEditorNum;
    }

    public boolean isDirty() {
        return this.getCommandStack() != null && this.getCommandStack().isDirty();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == CommandStack.class) {
            return adapter.cast(this.getCommandStack());
        }
        if (adapter == IGotoMarker.class) {
            return adapter.cast(this.getNavigationLocationProvider());
        }
        return (T)super.getAdapter(adapter);
    }

    public void stackChanged(CommandStackEvent event) {
        this.firePropertyChange(257);
    }

    public void dispose() {
        if (this.getCommandStack() != null) {
            this.getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        }
        super.dispose();
    }

    public void gotoMarker(IMarker marker) {
        try {
            Map attrs = marker.getAttributes();
            if (FordiacMarkerHelper.markerTargetsFBNetworkElement((Map)attrs)) {
                this.gotoFBNetworkElement(attrs.get("location"));
            } else if (FordiacMarkerHelper.markerTargetsConnection((Map)attrs)) {
                this.gotoConnection(marker);
            } else if (FordiacMarkerHelper.markerTargetsValue((Map)attrs)) {
                this.gotoValue(marker);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void gotoConnection(IMarker marker) {
        ErrorMarkerRef errorRef = FordiacMarkerHelper.getMarkerRefById((Long)marker.getId());
        FBNetworkElement parent = errorRef instanceof ErrorMarkerInterface ? ((ErrorMarkerInterface)errorRef).getFBNetworkElement() : null;
        this.selectErrorRef(errorRef, parent);
    }

    protected void gotoValue(IMarker marker) {
        ErrorMarkerRef errorRef = FordiacMarkerHelper.getMarkerRefById((Long)marker.getId());
        FBNetworkElement parent = errorRef instanceof Value ? ((Value)errorRef).getVarDeclaration().getFBNetworkElement() : null;
        this.selectErrorRef(errorRef, parent);
    }

    private void selectErrorRef(ErrorMarkerRef errorRef, FBNetworkElement parent) {
        if (parent != null) {
            EObject toView = parent.eContainer().eContainer();
            this.getBreadcrumb().setInput(toView);
            HandlerHelper.selectElement((Object)errorRef, this.getActiveEditor());
        }
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return null;
    }

    public INavigationLocation createNavigationLocation() {
        Object modelItem = this.breadcrumb.getActiveItem().getModel();
        return modelItem != null ? new BreadcrumbNavigationLocation(this, modelItem) : null;
    }

    public void saveState(IMemento memento) {
        StringBuilder itemPath = new StringBuilder();
        BreadcrumbNavigationLocation.generateItemPath(itemPath, this.getBreadcrumb().getActiveItem().getModel(), this.getBreadcrumb().getContentProvider(), this.getBreadcrumb().getLabelProvider());
        memento.putString(TAG_BREADCRUMB_HIERACHY, itemPath.substring(1));
        GraphicalViewer viewer = (GraphicalViewer)this.getActiveEditor().getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            AbstractBreadCrumbEditor.saveGraphicalViewerState(viewer, memento);
        }
    }

    protected static void saveGraphicalViewerState(GraphicalViewer viewer, IMemento memento) {
        if (viewer.getRootEditPart() instanceof ScalableFreeformRootEditPart) {
            memento.putFloat(TAG_GRAPHICAL_VIEWER_ZOOM, (float)((ScalableFreeformRootEditPart)viewer.getRootEditPart()).getZoomManager().getZoom());
        }
        if (viewer.getControl() instanceof FigureCanvas) {
            FigureCanvas canvas = (FigureCanvas)viewer.getControl();
            Point location = canvas.getViewport().getViewLocation();
            memento.putInteger(TAG_GRAPHICAL_VIEWER_HOR_SCROLL, location.x);
            memento.putInteger(TAG_GRAPHICAL_VIEWER_VER_SCROLL, location.y);
        }
    }

    public void restoreState(IMemento memento) {
        this.memento = memento;
    }

    private static void restoreGraphicalViewerState(GraphicalViewer viewer, IMemento memento) {
        Float zoom;
        if (viewer.getRootEditPart() instanceof ScalableFreeformRootEditPart && (zoom = memento.getFloat(TAG_GRAPHICAL_VIEWER_ZOOM)) != null) {
            ((ScalableFreeformRootEditPart)viewer.getRootEditPart()).getZoomManager().setZoom(zoom.doubleValue());
        }
        if (viewer.getControl() instanceof FigureCanvas) {
            FigureCanvas canvas = (FigureCanvas)viewer.getControl();
            Integer xLocation = memento.getInteger(TAG_GRAPHICAL_VIEWER_HOR_SCROLL);
            Integer yLocation = memento.getInteger(TAG_GRAPHICAL_VIEWER_VER_SCROLL);
            if (xLocation != null && yLocation != null) {
                Display.getDefault().asyncExec(() -> canvas.scrollTo(xLocation.intValue(), yLocation.intValue()));
            }
        }
    }

    public abstract CommandStack getCommandStack();

    protected abstract void gotoFBNetworkElement(Object var1);

    protected abstract EditorPart createEditorPart(Object var1);

    protected abstract IEditorInput createEditorInput(Object var1);

    protected abstract AdapterFactoryContentProvider createBreadcrumbContentProvider();

    protected abstract AdapterFactoryLabelProvider createBreadcrumbLabelProvider();

    protected abstract Object getInitialModel(String var1);
}

