/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.ui.Messages;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class Open4DIACElementAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.fordiac.ide.model.ui.OpenAction";

    public Open4DIACElementAction(IWorkbenchPart part) {
        super(Messages.OpenEditorAction_text);
        this.setId(ID);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object model = Open4DIACElementAction.convertFromEditPart(this.getStructuredSelection().getFirstElement());
        this.customizeOpenMenu(model);
        return model instanceof Device || model instanceof SystemConfiguration || model instanceof Application || model instanceof SubApp || model instanceof CFBInstance || model instanceof Resource;
    }

    private void customizeOpenMenu(Object model) {
        if (Open4DIACElementAction.isTypedSubAppOrCFBInstance(model)) {
            this.setText(Messages.OpenEditorAction_viewertext);
        } else {
            this.setText(Messages.OpenEditorAction_text);
        }
    }

    public void run() {
        Object selected = Open4DIACElementAction.convertFromEditPart(this.getStructuredSelection().getFirstElement());
        Object refObject = null;
        if (!(selected instanceof FB) || Open4DIACElementAction.isTypedComposite(selected)) {
            if (selected instanceof Device) {
                refObject = selected;
                selected = ((Device)selected).getSystemConfiguration();
            } else if (selected instanceof Segment) {
                refObject = selected;
                selected = ((Segment)refObject).eContainer();
            }
        }
        IEditorPart editor = OpenListenerManager.openEditor((EObject)selected);
        HandlerHelper.selectElement(refObject, editor);
    }

    private static boolean isTypedSubAppOrCFBInstance(Object obj) {
        if (obj instanceof SubApp) {
            return ((SubApp)obj).isTyped() || ((SubApp)obj).isContainedInTypedInstance();
        }
        if (obj instanceof FB) {
            return Open4DIACElementAction.isTypedComposite(obj);
        }
        return false;
    }

    private static boolean isTypedComposite(Object obj) {
        return obj instanceof CFBInstance;
    }

    private static Object convertFromEditPart(Object model) {
        if (model instanceof EditPart) {
            model = ((EditPart)model).getModel();
        }
        return model;
    }
}

