/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.metrics.analyzers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.metrics.analyzers.AbstractCodeMetricAnalyzer;
import org.eclipse.fordiac.ide.metrics.analyzers.HalsteadData;
import org.eclipse.fordiac.ide.metrics.analyzers.MetricData;
import org.eclipse.fordiac.ide.metrics.analyzers.MetricResult;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;

public class HalsteadMetric
extends AbstractCodeMetricAnalyzer {
    @Override
    protected HalsteadData analyzeBFB(BasicFBType basicFBType) {
        HalsteadData data = new HalsteadData();
        ECC ecc = basicFBType.getECC();
        for (ECTransition trans : ecc.getECTransition()) {
            if (!data.transCond.contains(trans.getConditionExpression())) {
                ++data.uniqueTrans;
            }
            data.transCond.add(trans.getConditionExpression());
        }
        for (ECState state : ecc.getECState()) {
            for (ECAction action : state.getECAction()) {
                HalsteadMetric.analyzeAction(action, data);
            }
        }
        data.uniqueOperands += (double)data.uniqueTrans;
        data.uniqueOperator += (double)data.uniqueTrans;
        data.operators += (double)(data.actions.size() + data.transCond.size());
        data.operands += (double)(data.event.size() + data.alg.size() + data.transCond.size());
        Object object = data.opCount;
        int n = data.opCount.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = object[n2];
            if ((double)element >= 1.0) {
                data.uniqueOperatorST += 1.0;
            }
            ++n2;
        }
        data.n2Major = data.operands + data.operandST;
        data.n2 = data.uniqueOperands + data.operandST;
        data.n1Major = data.operators + data.operatorST;
        data.n1 = data.uniqueOperator + data.uniqueOperatorST;
        return data;
    }

    private static void analyzeAction(ECAction action, HalsteadData data) {
        if (!data.actions.contains("Action " + data.actionCount)) {
            data.uniqueOperator += 1.0;
        }
        data.actions.add("Action " + data.actionCount);
        if (action.getOutput() != null) {
            if (!data.event.contains(action.getOutput().getName())) {
                data.uniqueOperands += 1.0;
            }
            data.event.add(action.getOutput().getName());
        }
        if (action.getAlgorithm() != null) {
            HalsteadMetric.analyzeAlgorithm(action.getAlgorithm(), data);
        }
        ++data.actionCount;
    }

    private static void analyzeAlgorithm(Algorithm algorithm, HalsteadData data) {
        if (!data.alg.contains(algorithm.getName())) {
            data.uniqueOperands += 1.0;
        }
        data.alg.add(algorithm.getName());
        String algo = algorithm.toString();
        int count = 0;
        String[] stringArray = HalsteadData.ST_OPERATORS;
        int n = HalsteadData.ST_OPERATORS.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            int lastIndex = 0;
            while (-1 != lastIndex) {
                if (-1 == (lastIndex = algo.indexOf(op, lastIndex))) continue;
                data.operatorST += 1.0;
                int n3 = count;
                data.opCount[n3] = data.opCount[n3] + 1;
                data.operandST += (double)HalsteadData.ST_OPERANDS_WEIGHT[count];
                String sub1 = algo.substring(0, lastIndex);
                String sub2 = algo.substring(lastIndex + op.length(), algo.length());
                algo = sub1.concat(sub2);
            }
            ++count;
            ++n2;
        }
    }

    @Override
    public List<MetricResult> getResults() {
        ArrayList<MetricResult> results = new ArrayList<MetricResult>();
        HalsteadData hData = (HalsteadData)this.data;
        results.add(new MetricResult("Distinct operators n1 ", hData.n1));
        results.add(new MetricResult("Distinct operands n2", hData.n2));
        results.add(new MetricResult("Total number of operators N1", hData.n1Major));
        results.add(new MetricResult("Total number of operands N2", hData.n2Major));
        double nMAjor = hData.n1Major + hData.n2Major;
        double n = hData.n1 + hData.n2;
        double nHat = hData.n1 * Math.log(hData.n1) / Math.log(2.0) + hData.n2 * Math.log(hData.n2) / Math.log(2.0);
        double pr = nHat / nMAjor;
        double v = nMAjor * Math.log(n) / Math.log(2.0);
        double d = hData.n1 / 2.0 * hData.n2Major / hData.n2;
        double e = d * v;
        results.add(new MetricResult("Program Length N", nMAjor));
        results.add(new MetricResult("Program vocabulary n", n));
        results.add(new MetricResult("Estimated length N^", nHat));
        results.add(new MetricResult("Purity ratio PR", pr));
        results.add(new MetricResult("Program volume V", v));
        results.add(new MetricResult("Difficulty D", d));
        results.add(new MetricResult("Program Effort E", e));
        return results;
    }

    @Override
    protected MetricData createDataType() {
        return new HalsteadData();
    }
}

