/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.metrics.analyzers;

import java.util.List;
import org.eclipse.fordiac.ide.metrics.analyzers.MetricData;
import org.eclipse.fordiac.ide.metrics.analyzers.MetricResult;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public abstract class AbstractCodeMetricAnalyzer {
    MetricData data;

    public void calculateMetrics(INamedElement element) {
        if (element instanceof FB) {
            element = ((FB)element).getPaletteEntry().getType();
        }
        if (element instanceof Application) {
            this.data = this.analyzeFBNetwork(((Application)element).getFBNetwork(), true);
        } else if (element instanceof SubApp) {
            this.data = this.analyzeSubApp((SubApp)element, true);
        } else if (element instanceof FBType) {
            this.data = this.analyzeFBType((FBType)element);
        }
    }

    public abstract List<MetricResult> getResults();

    protected MetricData analyzeSubApp(SubApp subApp, boolean calcAvg) {
        if (subApp.isTyped()) {
            return this.analyzeFBNetwork(subApp.getType().getFBNetwork(), true);
        }
        return this.analyzeFBNetwork(subApp.getSubAppNetwork(), calcAvg);
    }

    protected MetricData analyzeFBType(FBType type) {
        MetricData tempData = null;
        if (type instanceof BasicFBType) {
            tempData = this.analyzeBFB((BasicFBType)type);
        } else if (type instanceof CompositeFBType) {
            tempData = this.analyzeCFB((CompositeFBType)type);
        }
        return tempData;
    }

    protected MetricData analyzeFBNetwork(FBNetwork fbNetwork, boolean calcAvg) {
        MetricData tempData = this.createDataType();
        int cnt = 0;
        for (FBNetworkElement fb : fbNetwork.getNetworkElements()) {
            if (fb instanceof SubApp) {
                MetricData tempData2 = this.analyzeSubApp((SubApp)fb, false);
                cnt = tempData2.cnt == 0 ? ++cnt : (cnt += tempData2.cnt);
                tempData.add(tempData2);
                continue;
            }
            tempData.add(this.analyzeFBType(fb.getType()));
            ++cnt;
        }
        if (calcAvg) {
            tempData.divide(cnt);
        } else {
            tempData.cnt = cnt;
        }
        return tempData;
    }

    protected abstract MetricData analyzeBFB(BasicFBType var1);

    protected MetricData analyzeCFB(CompositeFBType compositeFBType) {
        return this.analyzeFBNetwork(compositeFBType.getFBNetwork(), true);
    }

    protected abstract MetricData createDataType();
}

