/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.interactors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.fordiac.ide.deployment.IDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.util.DeploymentHelper;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener;
import org.eclipse.fordiac.ide.model.libraryElement.Device;

public abstract class AbstractDeviceManagementInteractor
implements IDeviceManagementInteractor {
    private final IDeviceManagementCommunicationHandler commHandler;
    private final Device device;
    private Set<String> fbTypes = Collections.emptySet();
    private Set<String> adapterTypes = Collections.emptySet();
    private final List<IDeploymentListener> listeners = new ArrayList<IDeploymentListener>();

    @Override
    public boolean isConnected() {
        return this.commHandler.isConnected();
    }

    @Override
    public void connect() throws DeploymentException {
        this.commHandler.connect(DeploymentHelper.getMgrID(this.device));
        for (IDeploymentListener listener : this.listeners) {
            listener.connectionOpened();
        }
    }

    @Override
    public void disconnect() throws DeploymentException {
        this.commHandler.disconnect();
        for (IDeploymentListener listener : this.listeners) {
            listener.connectionClosed();
        }
    }

    public synchronized String sendREQ(String destination, String request) throws IOException {
        String response = this.commHandler.sendREQ(destination, request);
        for (IDeploymentListener listener : this.listeners) {
            listener.postCommandSent(this.commHandler.getInfo(destination), destination, request);
        }
        if (response.length() != 0) {
            for (IDeploymentListener listener : this.listeners) {
                listener.postResponseReceived(response, destination);
            }
        }
        return response;
    }

    @Override
    public void addDeploymentListener(IDeploymentListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeDeploymentListener(IDeploymentListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    protected AbstractDeviceManagementInteractor(Device dev, IDeviceManagementCommunicationHandler overrideHandler) {
        this.device = dev;
        this.resetTypes();
        this.commHandler = overrideHandler != null ? overrideHandler : this.createCommunicationHandler(dev);
    }

    protected Device getDevice() {
        return this.device;
    }

    public Set<String> getTypes() {
        return this.fbTypes;
    }

    protected void setTypes(Set<String> types) {
        this.fbTypes = types != null ? types : Collections.emptySet();
    }

    public Set<String> getAdapterTypes() {
        return this.adapterTypes;
    }

    protected void setAdapterTypes(Set<String> types) {
        this.adapterTypes = types != null ? types : Collections.emptySet();
    }

    protected final void resetTypes() {
        this.fbTypes = Collections.emptySet();
        this.adapterTypes = Collections.emptySet();
    }

    protected abstract IDeviceManagementCommunicationHandler createCommunicationHandler(Device var1);
}

