# frozen_string_literal: true

class ScheduleFixingNamespaceIdsOfVulnerabilityReads < Gitlab::Database::Migration[2.1]
  MIGRATION = 'FixNamespaceIdsOfVulnerabilityReads'

  disable_ddl_transaction!

  restrict_gitlab_migration gitlab_schema: :gitlab_main

  def up
    queue_batched_background_migration(
      MIGRATION,
      :vulnerability_reads,
      :vulnerability_id,
      job_interval: 2.minutes,
      batch_size: 10_000,
      sub_batch_size: 100
    )
  end

  def down
    delete_batched_background_migration(MIGRATION, :vulnerability_reads, :vulnerability_id, [])
  end
end
