/* pkchar.h							-*- C++ -*-
   Time-stamp: "97/01/03 17:55:45 mik"

   Copyright (C) 1991, 92, 93, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef _pkchar_h
#define _pkchar_h

#include "common.h"

#ifdef USE_MFC
class _DVI_1 _pkchar : public CObject
#else
class _DVI_1 _pkchar
#endif

{
public:
  _pkchar ();
  ~_pkchar ();
  enum dvi_bool read (_ifwrdstream &, int, dvi_integer);
  inline dvi_integer code () const;
  inline dvi_integer hpixels () const;
  inline dvi_integer vpixels () const;
  inline dvi_integer width () const;
  inline dvi_integer escapement () const;
  inline dvi_integer hoffset () const;
  inline dvi_integer voffset () const;
  inline const void *bitmap () const;
  void makebitmap ();

protected:
  typedef short int rword_t;	// 16-bit raster word
  int flag;			// flag byte
  dvi_integer pl;		// length (in bytes) of packed raster data
  dvi_integer cc;		// character code
  dvi_integer tfm;		// tfm width of the character (already scaled)
  dvi_integer dx;		// horizontal escapement in pixels
  dvi_integer w;		// width in pixels of minimum bounding box
  dvi_integer h;		// height in pixels of minimum bounding box
  dvi_integer hoff;		// horizontal offset
  dvi_integer voff;		// vertical offset
  dvi_byte *praster;		// the packed raster data
  rword_t *raster;		// the unpacked raster data

  static dvi_integer rword_width; // width of character bitmap in raster words
  static int dyn_f;		// dynamic packing variable
  static dvi_bool turn_on;	// are we black here?

  static int input_byte;	// the byte we are currently decimating
  static int bit_weight;	// weight of the current bit
  static const dvi_byte *pras;
  static rword_t rword;		// contains partially created raster word
  static dvi_integer rword_weight; // weight of the current position
  static const dvi_integer power[32]; // contains the powers of two
  static const dvi_integer gpower[33]; // contains various rows of black
  static dvi_integer repeat_count;
  static dvi_integer cur_x;

  inline int l3 () const;	// return the lower 3 bits of the flag byte
  dvi_bool isshort () const;
  dvi_bool isxshort () const;
  dvi_bool islong () const;
  int getbyte () const;
  int getnybble ();
  dvi_bool getbit ();
  dvi_integer getpackednumber ();
  void unpack ();
#if defined (RASTER_DEBUG)
  void printraster () const;
#endif
};

inline int
_pkchar::l3 () const

{
  return (flag & 7);
}

inline dvi_integer
_pkchar::code () const

{
  return (cc);
}

inline dvi_integer
_pkchar::hpixels () const

{
  return (w);
}

inline dvi_integer
_pkchar::vpixels () const

{
  return (h);
}

inline dvi_integer
_pkchar::width () const

{
  return (tfm);
}

inline dvi_integer
_pkchar::escapement () const

{
  return (dx);
}

inline dvi_integer
_pkchar::hoffset () const

{
  return (hoff);
}

inline dvi_integer
_pkchar::voffset () const

{
  return (voff);
}

inline const void *
_pkchar::bitmap () const

{
  return (raster);
}

#endif /* _pkchar_h */
