/* common.h							-*- C++ -*-
   Time-stamp: "97/08/03 02:30:46 mik"

   Copyright (C) 1991, 92, 93, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef _common_h
#define _common_h

#ifdef USE_STREAMIO
#include <fstream.h>
#else
#include <stdio.h>
#endif

#include <stdlib.h>

#include "dvi.h"

#if ! defined (_DVI_1)
#define _DVI_1
#endif

#if ! defined (_DVI_2)
#define _DVI_2
#endif

typedef unsigned char dvi_byte;

#ifdef USE_STREAMIO
class _ifwrdstream : public ifstream

{
public:
  inline _ifwrdstream (const char *);
  inline short readbyte ();
  inline short readsignedbyte ();
  inline long readpair ();
  inline long readsignedpair ();
  inline long readtrio ();
  inline long readsignedtrio ();
  inline long readsignedquad ();
  inline _ifwrdstream &skipg (streamoff);

protected:
  char buf[4];
  inline short makebyte (const char *) const;
  inline short makesignedbyte (const char *) const;
  inline long makepair (const char *) const;
  inline long makesignedpair (const char *) const;
  inline long maketrio (const char *) const;
  inline long makesignedtrio (const char *) const;
  inline long makesignedquad (const char *) const;
};

inline
_ifwrdstream::_ifwrdstream (const char *_filename)
  
  : ifstream (_filename, ios::in | ios::binary | ios::nocreate)

{
  ;
}

inline short
_ifwrdstream::makebyte (const char *_p) const

{
  return (*_p & 0xff);
}

inline short
_ifwrdstream::makesignedbyte (const char *_p) const

{
  return (*_p);
}

inline long
_ifwrdstream::makepair (const char *_p) const

{
  return ((makebyte (_p) << 8 | makebyte (_p+1)) & 0xffff);
}

inline long
_ifwrdstream::makesignedpair (const char *_p) const

{
  return (makesignedbyte (_p) << 8 | makebyte (_p+1));
}

inline long
_ifwrdstream::maketrio (const char *_p) const

{
  return ((((long) makebyte (_p) << 16) | makepair (_p+1)) & 0x00ffffff);
}

inline long
_ifwrdstream::makesignedtrio (const char *_p) const

{
  return (((long) makesignedbyte (_p) << 16) | makepair (_p+1));
}

inline long
_ifwrdstream::makesignedquad (const char *_p) const

{
  return (makesignedpair (_p) << 16 | makepair (_p+2));
}

inline short
_ifwrdstream::readbyte ()

{
  read (buf, 1);
  return (buf[0] & 0xff);
}

inline short
_ifwrdstream::readsignedbyte ()

{
  read (buf, 1);
  return (buf[0]);
}

inline long
_ifwrdstream::readpair ()

{
  read (buf, 2);
  return (makepair (buf));
}

inline long
_ifwrdstream::readsignedpair ()

{
  read (buf, 2);
  return (makesignedpair (buf));
}

inline long
_ifwrdstream::readtrio ()

{
  read (buf, 3);
  return (maketrio (buf));
}

inline long
_ifwrdstream::readsignedtrio ()

{
  read (buf, 3);
  return (makesignedtrio (buf));
}

inline long
_ifwrdstream::readsignedquad ()

{
  read (buf, 4);
  return (makesignedquad (buf));
}

inline _ifwrdstream &
_ifwrdstream::skipg (streamoff _count)

{
  seekg (_count, ios::cur);
  return (*this);
}
#else
#ifdef USE_MFC
class _ifwrdstream : public CObject
#else
class _ifwrdstream
#endif

{
public:
  enum {beg = SEEK_SET, end = SEEK_END, cur = SEEK_CUR};
  _ifwrdstream (const char *);
  ~_ifwrdstream ();
  inline short readbyte ();
  inline short readsignedbyte ();
  inline long readpair ();
  inline long readsignedpair ();
  inline long readtrio ();
  inline long readsignedtrio ();
  inline long readsignedquad ();
  inline _ifwrdstream &skipg (long);
  inline int eof ();
  inline int is_open ();
  inline int good ();
  inline _ifwrdstream &read (char *, int);
  inline _ifwrdstream &read (signed char *, int);
  inline _ifwrdstream &read (unsigned char *, int);
  inline void open (const char *);
  inline _ifwrdstream &seekg (long, int);
  inline long tellg ();

protected:
  char buf[4];
  FILE *stream;
  inline short makebyte (const char *) const;
  inline short makesignedbyte (const char *) const;
  inline long makepair (const char *) const;
  inline long makesignedpair (const char *) const;
  inline long maketrio (const char *) const;
  inline long makesignedtrio (const char *) const;
  inline long makesignedquad (const char *) const;
};

inline short
_ifwrdstream::makebyte (const char *_p) const

{
  return (*_p & 0xff);
}

inline short
_ifwrdstream::makesignedbyte (const char *_p) const

{
  return (*_p);
}

inline long
_ifwrdstream::makepair (const char *_p) const

{
  return ((makebyte (_p) << 8 | makebyte (_p+1)) & 0xffff);
}

inline long
_ifwrdstream::makesignedpair (const char *_p) const

{
  return (makesignedbyte (_p) << 8 | makebyte (_p+1));
}

inline long
_ifwrdstream::maketrio (const char *_p) const

{
  return ((((long) makebyte (_p) << 16) | makepair (_p+1)) & 0x00ffffff);
}

inline long
_ifwrdstream::makesignedtrio (const char *_p) const

{
  return (((long) makesignedbyte (_p) << 16) | makepair (_p+1));
}

inline long
_ifwrdstream::makesignedquad (const char *_p) const

{
  return (makesignedpair (_p) << 16 | makepair (_p+2));
}

inline short
_ifwrdstream::readbyte ()

{
  read ((signed char *) buf, 1);
  return (buf[0] & 0xff);
}

inline short
_ifwrdstream::readsignedbyte ()

{
  read ((signed char *) buf, 1);
  return (buf[0]);
}

inline long
_ifwrdstream::readpair ()

{
  read ((signed char *) buf, 2);
  return (makepair (buf));
}

inline long
_ifwrdstream::readsignedpair ()

{
  read ((signed char *) buf, 2);
  return (makesignedpair (buf));
}

inline long
_ifwrdstream::readtrio ()

{
  read ((signed char *) buf, 3);
  return (maketrio (buf));
}

inline long
_ifwrdstream::readsignedtrio ()

{
  read ((signed char *) buf, 3);
  return (makesignedtrio (buf));
}

inline long
_ifwrdstream::readsignedquad ()

{
  read ((signed char *) buf, 4);
  return (makesignedquad (buf));
}

inline _ifwrdstream &
_ifwrdstream::skipg (long _count)

{
  fseek (stream, _count, SEEK_CUR);
  return (*this);
}

inline int
_ifwrdstream::is_open ()

{
  return (stream != 0);
}

inline int
_ifwrdstream::eof ()

{
  return (feof (stream));
}

inline int
_ifwrdstream::good ()

{
  return (stream && ferror (stream) == 0);
}

inline _ifwrdstream &
_ifwrdstream::read (char *buf,
		    int len)

{
  fread (buf, 1, len, stream);
  return (*this);
}

inline _ifwrdstream &
_ifwrdstream::read (unsigned char *buf,
		    int len)

{
  fread (buf, 1, len, stream);
  return (*this);
}

inline _ifwrdstream &
_ifwrdstream::read (signed char *buf,
		    int len)

{
  fread (buf, 1, len, stream);
  return (*this);
}

inline void
_ifwrdstream::open (const char *filename)

{
  stream = fopen (filename, "rb");
}

inline _ifwrdstream &
_ifwrdstream::seekg (long offset, int origin)

{
  fseek (stream, offset, origin);
  return (*this);
}

inline long
_ifwrdstream::tellg ()

{
  return (ftell (stream));
}
#endif

#if defined (DEBUG_OUTPUT)

void dprintf (const char *, ...);
void dputchar (int);

#define dprintf1 dprintf
#define dprintf2 dprintf
#define dprintf3 dprintf
#define dprintf4 dprintf
#define dprintf5 dprintf
#define dprintf6 dprintf
#define dprintf7 dprintf

#else

#define dputchar(a)
#define dprintf(a)
#define dprintf1(a, b)
#define dprintf2(a, b, c)
#define dprintf3(a, b, c, d)
#define dprintf4(a, b, c, d, e)
#define dprintf5(a, b, c, d, e, f)
#define dprintf6(a, b, c, d, e, f, g)
#define dprintf7(a, b, c, d, e, f, g, h)

#endif

#endif
