/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MedlineParser {
    public MedlineParser(String string) {
        MedlineParser.readMedline(string);
    }

    static ArrayList readMedline(String string) {
        File file = new File(string);
        if (!(file.exists() || file.canRead() || file.isFile())) {
            System.err.println("Error " + string + " is not a valid file and|or is not readable.");
            return null;
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        sAXParserFactory.setNamespaceAware(true);
        ArrayList arrayList = null;
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            MedlineHandler medlineHandler = new MedlineHandler();
            sAXParser.parse(new File(string), (DefaultHandler)medlineHandler);
            arrayList = medlineHandler.getItems();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return arrayList;
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        ArrayList arrayList = MedlineParser.readMedline(string);
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                System.out.println(((Bibitem)iterator.next()).toString());
            }
        }
    }

    public static class MedlineHandler
    extends DefaultHandler {
        ArrayList bibitems = new ArrayList();
        boolean inTitle = false;
        boolean inYear = false;
        boolean inJournal = false;
        boolean inMonth = false;
        boolean inVolume = false;
        boolean inAuthorList = false;
        boolean inAuthor = false;
        boolean inLastName = false;
        boolean inInitials = false;
        boolean inMedlinePgn = false;
        boolean inMedlineID = false;
        boolean inURL = false;
        boolean inIssue = false;
        boolean inPubDate = false;
        boolean inUrl = false;
        boolean inForename = false;
        boolean inAbstractText = false;
        String title = "";
        String journal = "";
        String keyword = "";
        String author = "";
        String lastName = "";
        String year = "";
        String forename = "";
        String abstractText = "";
        String month = "";
        String volume = "";
        String lastname = "";
        String initials = "";
        String number = "";
        String page = "";
        String medlineID = "";
        String url = "";
        ArrayList authors = new ArrayList();

        public ArrayList getItems() {
            return this.bibitems;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (!string2.equals("PubmedArticle")) {
                if (string2.equals("ArticleTitle")) {
                    this.inTitle = true;
                    this.title = "";
                } else if (string2.equals("PubDate")) {
                    this.inPubDate = true;
                } else if (string2.equals("Year") && this.inPubDate) {
                    this.inYear = true;
                } else if (string2.equals("MedlineTA")) {
                    this.inJournal = true;
                    this.journal = "";
                } else if (string2.equals("Month") && this.inPubDate) {
                    this.inMonth = true;
                } else if (string2.equals("Volume")) {
                    this.inVolume = true;
                } else if (string2.equals("AuthorList")) {
                    this.inAuthorList = true;
                    this.authors.clear();
                    this.keyword = "";
                } else if (string2.equals("Author")) {
                    this.inAuthor = true;
                    this.author = "";
                } else if (string2.equals("LastName")) {
                    this.inLastName = true;
                    this.lastName = "";
                } else if (string2.equals("ForeName")) {
                    this.forename = "";
                } else if (string2.equals("Issue")) {
                    this.inIssue = true;
                } else if (string2.equals("MedlinePgn")) {
                    this.inMedlinePgn = true;
                } else if (string2.equals("URL")) {
                    this.inUrl = true;
                } else if (string2.equals("Initials")) {
                    this.inInitials = true;
                } else if (string2.equals("AbstractText")) {
                    this.inAbstractText = true;
                }
            }
        }

        String join(Object[] objectArray, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(objectArray[0].toString());
            int n = 1;
            while (n < objectArray.length) {
                stringBuffer.append(string);
                stringBuffer.append(objectArray[n].toString());
                ++n;
            }
            return stringBuffer.toString();
        }

        String makeBibtexString() {
            String string = "";
            string = "Article{,\n author = { " + this.author + " },\n title = { " + this.title + "},\n journal ={ " + this.journal + "},\n year = " + this.year + "},\n volume = { " + this.volume + "},\n number = { " + this.number + "},\n pages = { " + this.page + "},\n abstract = { " + this.abstractText + "},\n}";
            return string;
        }

        public void endElement(String string, String string2, String string3) {
            if (string2.equals("PubmedArticle")) {
                this.bibitems.add(new Bibitem(this.makeBibtexString()));
                this.abstractText = "";
                this.author = "";
                this.title = "";
                this.journal = "";
                this.keyword = "";
                this.year = "";
                this.forename = "";
                this.abstractText = "";
                this.month = "";
                this.volume = "";
                this.lastname = "";
                this.initials = "";
                this.number = "";
                this.page = "";
                this.medlineID = "";
                this.url = "";
            } else if (string2.equals("ArticleTitle")) {
                this.inTitle = false;
            } else if (string2.equals("PubDate")) {
                this.inPubDate = false;
            } else if (string2.equals("Year")) {
                this.inYear = false;
            } else if (string2.equals("MedlineTA")) {
                this.inJournal = false;
            } else if (string2.equals("Month")) {
                this.inMonth = false;
            } else if (string2.equals("Volume")) {
                this.inVolume = false;
            } else if (string2.equals("AuthorList")) {
                this.author = this.join(this.authors.toArray(), " and ");
                this.inAuthorList = false;
            } else if (string2.equals("Author")) {
                this.author = this.initials + " " + this.lastname;
                this.authors.add(this.author);
                this.inAuthor = false;
            } else if (string2.equals("LastName")) {
                this.inLastName = false;
            } else if (string2.equals("ForeName")) {
                this.inForename = false;
            } else if (string2.equals("Issue")) {
                this.inIssue = false;
            } else if (string2.equals("MedlinePgn")) {
                this.inMedlinePgn = false;
            } else if (string2.equals("URL")) {
                this.inUrl = false;
            } else if (string2.equals("Initials")) {
                this.inInitials = false;
            } else if (string2.equals("AbstractText")) {
                this.inAbstractText = false;
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.inTitle) {
                this.title = new String(cArray, n, n2);
            } else if (this.inYear) {
                this.year = new String(cArray, n, n2);
            } else if (this.inJournal) {
                this.journal = new String(cArray, n, n2);
            } else if (this.inMonth) {
                this.month = new String(cArray, n, n2);
            } else if (this.inVolume) {
                this.volume = new String(cArray, n, n2);
            } else if (this.inLastName) {
                this.lastname = new String(cArray, n, n2);
            } else if (this.inInitials) {
                this.initials = new String(cArray, n, n2);
            } else if (this.inIssue) {
                this.number = new String(cArray, n, n2);
            } else if (this.inMedlinePgn) {
                this.page = new String(cArray, n, n2);
            } else if (this.inMedlineID) {
                this.medlineID = new String(cArray, n, n2);
            } else if (this.inURL) {
                this.url = new String(cArray, n, n2);
            } else if (this.inForename) {
                this.forename = new String(cArray, n, n2);
            } else if (this.inAbstractText) {
                this.abstractText = this.abstractText + new String(cArray, n, n2);
            }
        }
    }
}

