#!/usr/bin/env python
# Michael Sharpe, June 30, 2009
# msharpe at ucsd.edu
# Display brief documentation of PSTricks commands, including keywords.
# Eg, pstdoc \rput (or pstdoc rput) will display the syntax and a brief explanation.
# The firat line may need to be changed for Linux, and some other mechanism used for Windows.
import sys
import os
import sqlite3
if len(sys.argv)==1:
	print "You must supply the name of a PST command"
	exit(2)

tab=u'\x09'
CSI=''
bgon=''
bgoff=''
redon=''
redoff=''
pkgs=('pstricks','pst-plot','pst-node','pstricks-add','pst-nodeExtras','pst-3dplot','pst-tree','multido','pst-eps','pst-bspline','pst-grapha','pst-coil','pst-text')
larrow=unichr(0x00ab) #u'\u21d0 '  # "<-"
bdelim=("{","(","[","")
edelim=("}",")","]","")
if sys.platform[:3]<>'win':
	CSI=u'\x1B['
	bgon=CSI+"43m"
	bgoff=CSI+"00m"
	redon=CSI+"31m"
	redoff=CSI+"30m"
	larrow=redon+u'\u21d0'+redoff+" "

def main(argv):
	conn = sqlite3.connect(os.path.dirname( os.path.realpath( __file__ ) )+'/pstCommands.db') 
	c=conn.cursor()
	if argv[0:1]<>'\\':
		argv='\\'+argv
	t=(argv,)
	c.execute('select cmdid, cmdname from Commands where cmdname=?',t)
	x=c.fetchone()
	cmdnum=0
	while not (x is None):
		if x[1]==argv:
			cmdnum=int(x[0])
		x=c.fetchone()
	if cmdnum==0:
		print "Command not found: ",argv
		c.execute("select cmdname from Commands where cmdname LIKE '"+argv+"%' order by cmdname")
		x=c.fetchone()
		print "Similar commands:"
		while not (x is None):
			print x[0]
			x=c.fetchone()
	else:
		t=(cmdnum,)
		c.execute('select * from Commands where cmdID=?',t)
		x=c.fetchone()
		#print x---there should be only one
		desc=x[6].split(tab) 
		isOpt=x[8]
		ti=[]
		ti.append(argv)
		if x[2]==1:
			ti.append(bgon+"*"+bgoff)
		if x[9]==1:
			ti.append(bgon+"[<kwds>]"+bgoff)
		L=len(x[7]) # delimiters
		delim=x[7]
		
		for i in range(0,L):
			k=int(delim[i])
			s=bdelim[k]+desc[i].replace('<-',larrow)+edelim[k]
			if isOpt[i]=='1':
				s=bgon+s+bgoff
			ti.append(s)
		if x[10]==1:
			ti.append("(<coords>)"+bgon+"..."+bgoff)
		ti.append("% "+x[5]+' ['+pkgs[x[11]]+']')
		print ""
		print ''.join(ti)
  		if x[9]==1:
			print "Keywords:"
			ss="select parName,parPat,parDefault,parDescription from Parameters where (parLimTo="+str(cmdnum)+") or ((parLimTo=0) and (parCat=0 or parCat="+str(x[1])+")) group by parName,parPat,parDefault,parDescription order by parname"
			c.execute(ss)
			for x in c:
				print redon+x[0]+redoff+" "+x[1]+redon+larrow+redoff+x[2]+" % "+x[3]

if __name__ == "__main__":
    main(sys.argv[1])