/* This file is a part of XBibFile - a system for handling BibTeX references
 *
 * Author:   Ross Maloney
 * Date:     October 1999
 * Modified: January 2001
 * Renamed, reformed, and reworked:   January 2002
 *
 */

#include  <stdio.h>
#include  <gtk/gtk.h>

/* This procedure get the name of the file that will be processed for 
 * cross reference information. */

void ref_file(GtkWidget *widget, GtkFileSelection *ref)
{
  extern  char slate40[];
  extern  int length[];
  extern  FILE *refFile;
  extern  void error();

  if (refFile) {
    g_print("The cross-file is currently open, I will shut it\n");
    fclose(refFile);
    refFile = 0;
  }
  strcpy(slate40, gtk_file_selection_get_filename(GTK_FILE_SELECTION(ref)));
  length[40] = strlen(slate40);
  refFile = fopen(slate40, "r");
  if (!refFile)  {
    error(widget, 7);
    return;
  }
}

/* This procedure is very similar to the procedure new_filename().
 * However, this procedure is designed to be called when the reference file
 * is to be searched.  It puts the selected filename in to a location
 * from which other parts of the program can access it, and
 * opens it, then calls the reference search tools. */

void  existing_filename(GtkWidget * widget, GtkFileSelection *new)
{
  extern  char slate0[];
  extern  int length[];
  extern  FILE *refFile;            /* defined in file  xbibfile.c */
  extern  void error();
  extern  void explore_tools();     /* contained in explore.c */

  if (refFile) {
    g_print("A file is currently open, I will shut it\n");
    fclose(refFile);
    refFile = 0;
  }
  strcpy(slate0, gtk_file_selection_get_filename(GTK_FILE_SELECTION(new)));
  length[0] = strlen(slate0);
  refFile = fopen(slate0, "r");
  if (!refFile)  {
    error(widget, 7);
    return;
  }
  probe_menu(widget);
}


/* This procedure allows the user to select the file for exploring the
 * reference information already stored in it */

void ref_select(GtkWidget *widget)
{
  GtkWidget  *crossFile;

  crossFile = gtk_file_selection_new("BibTeX database to review");
  gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(crossFile));

  gtk_file_selection_set_filename(GTK_FILE_SELECTION(crossFile),
                                  "penguin.bib");
  g_signal_connect(GTK_OBJECT(
                   GTK_FILE_SELECTION(crossFile)->ok_button),
                  "clicked", G_CALLBACK(existing_filename), crossFile);
  g_signal_connect_swapped(GTK_OBJECT(
                           GTK_FILE_SELECTION(crossFile)->cancel_button),
                           "clicked", G_CALLBACK(gtk_widget_destroy),
			   (gpointer) crossFile);

  gtk_widget_show(crossFile);
}



/* This procedure puts the selected filename in to a location
 * from which other parts of the program can access it, and
 * opens it, then calls the reference creation menu. */

void  new_filename(GtkWidget * widget, GtkFileSelection *new)
{
  extern  char slate0[];
  extern  int length[];
  extern  FILE *finput;
  extern  void error();
  extern  void available();     /* contained in selecting.c */

  if (finput) {
    g_print("A file is currently open, I will shut it\n");
    fclose(finput);
    finput = 0;
  }
  strcpy(slate0, gtk_file_selection_get_filename(GTK_FILE_SELECTION(new)));
  length[0] = strlen(slate0);
  finput = fopen(slate0, "a");
  if (!finput)  {
    error(widget, 7);
    return;
  }
  available(widget);
}


/* This procedure allows the user to select the file into which
 * the references are to be written */

void file_select(GtkWidget *widget)
{
  GtkWidget  *inputFile;


  inputFile = gtk_file_selection_new("BibTeX database to append");

  gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(inputFile));
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(inputFile),
                                  "penguin.bib");
  g_signal_connect(GTK_OBJECT(
                   GTK_FILE_SELECTION(inputFile)->ok_button),
                   "clicked", G_CALLBACK(new_filename), inputFile);
  g_signal_connect_swapped(GTK_OBJECT(
                           GTK_FILE_SELECTION(inputFile)->cancel_button),
                           "clicked", G_CALLBACK(gtk_widget_destroy),
			   (gpointer) inputFile);
//  g_signal_connect_swapped(GTK_OBJECT(
//                           GTK_FILE_SELECTION(inputFile)->ok_button),
//                           "clicked", G_CALLBACK(gtk_widget_destroy),
//			   (gpointer) inputFile);

  gtk_widget_show(inputFile);
}
