/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.wasm.ir.WasmImportDescriptor;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0002\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u0007*\u00020\u0002\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0007*\u00020\u0002\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0007*\u00020\u0005\u00a8\u0006\u0010"}, d2={"hasExcludedFromCodegenAnnotation", "", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "getWasmImportDescriptor", "Lorg/jetbrains/kotlin/wasm/ir/WasmImportDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getWasmOpAnnotation", "", "hasWasmNoOpCastAnnotation", "hasWasmAutoboxedAnnotation", "hasWasmPrimitiveConstructorAnnotation", "getWasmArrayAnnotation", "Lorg/jetbrains/kotlin/backend/wasm/utils/WasmArrayInfo;", "getJsFunAnnotation", "getJsPrimitiveType", "getWasmExportNameIfWasmExport", "backend.wasm"})
public final class AnnotationsKt {
    public static final boolean hasExcludedFromCodegenAnnotation(@NotNull IrAnnotationContainer $this$hasExcludedFromCodegenAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasExcludedFromCodegenAnnotation, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$hasExcludedFromCodegenAnnotation, new FqName("kotlin.wasm.internal.ExcludedFromCodegen"));
    }

    @Nullable
    public static final WasmImportDescriptor getWasmImportDescriptor(@NotNull IrFunction $this$getWasmImportDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$getWasmImportDescriptor, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getWasmImportDescriptor, new FqName("kotlin.wasm.WasmImport"));
        if (irConstructorCall == null) {
            return null;
        }
        IrConstructorCall annotation = irConstructorCall;
        Object e2 = annotation.getArguments().get(0);
        Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst");
        Object object = ((IrConst)e2).getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String moduleName2 = (String)object;
        Object e3 = annotation.getArguments().get(1);
        IrConst irConst = e3 instanceof IrConst ? (IrConst)e3 : null;
        Object object2 = irConst != null ? irConst.getValue() : null;
        String declarationName = object2 instanceof String ? (String)object2 : null;
        String string = declarationName;
        if (string == null) {
            String string2 = $this$getWasmImportDescriptor.getName().asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        }
        return new WasmImportDescriptor(moduleName2, (WasmSymbolReadOnly<String>)new WasmSymbol<String>(string));
    }

    @Nullable
    public static final String getWasmOpAnnotation(@NotNull IrAnnotationContainer $this$getWasmOpAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$getWasmOpAnnotation, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getWasmOpAnnotation, new FqName("kotlin.wasm.internal.WasmOp"));
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    public static final boolean hasWasmNoOpCastAnnotation(@NotNull IrAnnotationContainer $this$hasWasmNoOpCastAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasWasmNoOpCastAnnotation, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$hasWasmNoOpCastAnnotation, new FqName("kotlin.wasm.internal.WasmNoOpCast"));
    }

    public static final boolean hasWasmAutoboxedAnnotation(@NotNull IrAnnotationContainer $this$hasWasmAutoboxedAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasWasmAutoboxedAnnotation, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$hasWasmAutoboxedAnnotation, new FqName("kotlin.wasm.internal.WasmAutoboxed"));
    }

    public static final boolean hasWasmPrimitiveConstructorAnnotation(@NotNull IrAnnotationContainer $this$hasWasmPrimitiveConstructorAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasWasmPrimitiveConstructorAnnotation, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$hasWasmPrimitiveConstructorAnnotation, new FqName("kotlin.wasm.internal.WasmPrimitiveConstructor"));
    }

    @Nullable
    public static final WasmArrayInfo getWasmArrayAnnotation(@NotNull IrAnnotationContainer $this$getWasmArrayAnnotation) {
        WasmArrayInfo wasmArrayInfo;
        Intrinsics.checkNotNullParameter((Object)$this$getWasmArrayAnnotation, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getWasmArrayAnnotation, new FqName("kotlin.wasm.internal.WasmArrayOf"));
        if (irConstructorCall != null) {
            IrConstructorCall it = irConstructorCall;
            boolean bl = false;
            Object e2 = it.getArguments().get(0);
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrClassReference");
            IrSymbolOwner irSymbolOwner = ((IrClassReference)e2).getSymbol().getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            IrClass irClass = (IrClass)irSymbolOwner;
            Object e3 = it.getArguments().get(1);
            Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst");
            Object object = ((IrConst)e3).getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            Object e4 = it.getArguments().get(2);
            IrConst irConst = e4 instanceof IrConst ? (IrConst)e4 : null;
            Object object2 = irConst != null ? irConst.getValue() : null;
            Boolean bl2 = object2 instanceof Boolean ? (Boolean)object2 : null;
            wasmArrayInfo = new WasmArrayInfo(irClass, (Boolean)object, bl2 != null ? bl2 : true);
        } else {
            wasmArrayInfo = null;
        }
        return wasmArrayInfo;
    }

    @Nullable
    public static final String getJsFunAnnotation(@NotNull IrAnnotationContainer $this$getJsFunAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsFunAnnotation, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsFunAnnotation, new FqName("kotlin.JsFun"));
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    @Nullable
    public static final String getJsPrimitiveType(@NotNull IrAnnotationContainer $this$getJsPrimitiveType) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsPrimitiveType, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsPrimitiveType, new FqName("kotlin.wasm.internal.JsPrimitive"));
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    @Nullable
    public static final String getWasmExportNameIfWasmExport(@NotNull IrFunction $this$getWasmExportNameIfWasmExport) {
        Intrinsics.checkNotNullParameter((Object)$this$getWasmExportNameIfWasmExport, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getWasmExportNameIfWasmExport, new FqName("kotlin.wasm.WasmExport"));
        if (irConstructorCall == null) {
            return null;
        }
        IrConstructorCall annotation = irConstructorCall;
        if (annotation.getArguments().isEmpty()) {
            return $this$getWasmExportNameIfWasmExport.getName().getIdentifier();
        }
        Object e2 = annotation.getArguments().get(0);
        IrConst irConst = e2 instanceof IrConst ? (IrConst)e2 : null;
        Object object = irConst != null ? irConst.getValue() : null;
        String nameFromAnnotation = object instanceof String ? (String)object : null;
        String string = nameFromAnnotation;
        if (string == null) {
            String string2 = $this$getWasmExportNameIfWasmExport.getName().getIdentifier();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
        }
        return string;
    }
}

