/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

public class CheckBoxRenderer
extends JCheckBox
implements ProfilerRenderer {
    private Point sharedPoint;
    private Dimension sharedDimension;
    private Rectangle sharedRectangle;
    protected final Point location = new Point();
    protected final Dimension size = new Dimension();
    private final Insets insets = new Insets(0, 0, 0, 0);
    private Color foreground;
    private Color background;
    private boolean enabled = true;

    public CheckBoxRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
    }

    @Override
    public void setValue(Object value, int row) {
        if (value == null) {
            this.setSelected(false);
        } else {
            this.setSelected((Boolean)value);
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String toString() {
        return Boolean.toString(this.isSelected());
    }

    protected final Point sharedPoint(int x, int y) {
        if (this.sharedPoint == null) {
            this.sharedPoint = new Point();
        }
        this.sharedPoint.x = x;
        this.sharedPoint.y = y;
        return this.sharedPoint;
    }

    protected final Point sharedPoint(Point point) {
        return this.sharedPoint(point.x, point.y);
    }

    protected final Dimension sharedDimension(int width, int height) {
        if (this.sharedDimension == null) {
            this.sharedDimension = new Dimension();
        }
        this.sharedDimension.width = width;
        this.sharedDimension.height = height;
        return this.sharedDimension;
    }

    protected final Dimension sharedDimension(Dimension dimension) {
        return this.sharedDimension(dimension.width, dimension.height);
    }

    protected final Rectangle sharedRectangle(int x, int y, int width, int height) {
        if (this.sharedRectangle == null) {
            this.sharedRectangle = new Rectangle();
        }
        this.sharedRectangle.x = x;
        this.sharedRectangle.y = y;
        this.sharedRectangle.width = width;
        this.sharedRectangle.height = height;
        return this.sharedRectangle;
    }

    protected final Rectangle sharedRectangle(Rectangle rectangle) {
        return this.sharedRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void move(int x, int y) {
        this.location.x = x;
        this.location.y = y;
    }

    @Override
    public Point getLocation() {
        return this.sharedPoint(this.location);
    }

    @Override
    public int getX() {
        return this.location.x;
    }

    @Override
    public int getY() {
        return this.location.y;
    }

    @Override
    public void setSize(int w, int h) {
        this.size.width = w;
        this.size.height = h;
    }

    @Override
    public Dimension getSize() {
        return this.sharedDimension(this.size);
    }

    @Override
    public int getWidth() {
        return this.size.width;
    }

    @Override
    public int getHeight() {
        return this.size.height;
    }

    @Override
    public Rectangle getBounds() {
        return this.sharedRectangle(this.location.x, this.location.y, this.size.width, this.size.height);
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        this.size.width = w;
        this.size.height = h;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public Insets getInsets(Insets insets) {
        return this.insets;
    }

    @Override
    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public void setBackground(Color background) {
        this.background = background;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void setDisplayedMnemonicIndex(int index) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }
}

