/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.av;

import com.jogamp.common.av.AudioSink;
import com.jogamp.common.util.ReflectionUtil;
import jogamp.common.av.NullAudioSink;

public class AudioSinkFactory {
    private static final String ALAudioSinkClazzName = "com.jogamp.openal.util.ALAudioSink";
    private static final String JavaAudioSinkClazzName = "jogamp.common.av.JavaSoundAudioSink";

    public static AudioSink createDefault(ClassLoader classLoader) {
        AudioSink audioSink = AudioSinkFactory.create(classLoader, ALAudioSinkClazzName);
        if (null == audioSink) {
            audioSink = AudioSinkFactory.create(classLoader, JavaAudioSinkClazzName);
        }
        if (null == audioSink) {
            audioSink = AudioSinkFactory.createNull();
        }
        return audioSink;
    }

    public static AudioSink createNull() {
        return new NullAudioSink();
    }

    public static AudioSink create(ClassLoader classLoader, String string) {
        block5: {
            if (ReflectionUtil.isClassAvailable(string, classLoader)) {
                try {
                    AudioSink audioSink = (AudioSink)ReflectionUtil.createInstance(string, classLoader);
                    if (audioSink.isAvailable()) {
                        return audioSink;
                    }
                    if (AudioSink.DEBUG) {
                        System.err.println("AudioSinkFactory: Couldn't instantiate AudioSink '" + string + "'");
                    }
                }
                catch (Throwable throwable) {
                    if (!AudioSink.DEBUG) break block5;
                    System.err.println("Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
        }
        return null;
    }
}

