/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.TextureImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HomeTexture
implements TextureImage,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String catalogId;
    private final String name;
    private final String creator;
    private final Content image;
    private final float width;
    private final float height;
    private final float xOffset;
    private final float yOffset;
    private final float angle;
    private float scale;
    private boolean fittingArea;
    private final boolean leftToRightOriented;

    public HomeTexture(TextureImage textureImage) {
        this(textureImage, 0.0f);
    }

    public HomeTexture(TextureImage textureImage, float f) {
        this(textureImage, f, true);
    }

    public HomeTexture(TextureImage textureImage, float f, boolean bl) {
        this(textureImage, f, 1.0f, bl);
    }

    public HomeTexture(TextureImage textureImage, float f, float f2, boolean bl) {
        this(textureImage, 0.0f, 0.0f, f, f2, bl);
    }

    public HomeTexture(TextureImage textureImage, float f, float f2, float f3, float f4, boolean bl) {
        this(textureImage, f, f2, f3, f4, false, bl);
    }

    public HomeTexture(TextureImage textureImage, float f, float f2, float f3, float f4, boolean bl, boolean bl2) {
        this.name = textureImage.getName();
        this.creator = textureImage.getCreator();
        this.image = textureImage.getImage();
        this.width = textureImage.getWidth();
        this.height = textureImage.getHeight();
        this.xOffset = f;
        this.yOffset = f2;
        this.angle = f3;
        this.scale = f4;
        this.fittingArea = bl;
        this.leftToRightOriented = bl2;
        this.catalogId = textureImage instanceof HomeTexture ? ((HomeTexture)textureImage).getCatalogId() : (textureImage instanceof CatalogTexture ? ((CatalogTexture)textureImage).getId() : null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.scale = 1.0f;
        objectInputStream.defaultReadObject();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public Content getImage() {
        return this.image;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getScale() {
        return this.scale;
    }

    public boolean isFittingArea() {
        return this.fittingArea;
    }

    public void setFittingArea(boolean bl) {
        this.fittingArea = bl;
    }

    public boolean isLeftToRightOriented() {
        return this.leftToRightOriented;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof HomeTexture) {
            HomeTexture homeTexture = (HomeTexture)object;
            return (homeTexture.name == this.name || homeTexture.name != null && homeTexture.name.equals(this.name)) && (homeTexture.image == this.image || homeTexture.image != null && homeTexture.image.equals(this.image)) && homeTexture.width == this.width && homeTexture.height == this.height && homeTexture.xOffset == this.xOffset && homeTexture.yOffset == this.yOffset && homeTexture.fittingArea == this.fittingArea && homeTexture.leftToRightOriented == this.leftToRightOriented && homeTexture.angle == this.angle && homeTexture.scale == this.scale;
        }
        return false;
    }

    public int hashCode() {
        return (this.name != null ? this.name.hashCode() : 0) + (this.image != null ? this.image.hashCode() : 0) + Float.floatToIntBits(this.width) + Float.floatToIntBits(this.height) + Float.floatToIntBits(this.xOffset) + Float.floatToIntBits(this.yOffset) + Float.floatToIntBits(this.angle) + Float.floatToIntBits(this.scale);
    }
}

