/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNodeGen;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.call.special.SpecialMethodNotFound;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PythonOptions.class})
public abstract class LookupAndCallBinaryNode
extends Node {
    @Node.Child
    private CallBinaryMethodNode dispatchNode;
    protected final TruffleString name;

    LookupAndCallBinaryNode(TruffleString name) {
        this.name = name;
    }

    public abstract Object executeObject(VirtualFrame var1, Object var2, Object var3) throws SpecialMethodNotFound;

    @NeverDefault
    public static LookupAndCallBinaryNode create(TruffleString name) {
        return LookupAndCallBinaryNodeGen.create(name);
    }

    protected final CallBinaryMethodNode ensureDispatch() {
        if (this.dispatchNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.dispatchNode = (CallBinaryMethodNode)this.insert(CallBinaryMethodNode.create());
        }
        return this.dispatchNode;
    }

    protected final PythonBinaryBuiltinNode getBinaryBuiltin(PythonBuiltinClassType clazz) {
        PBuiltinFunction builtinFunction;
        Object attribute = LookupAttributeInMRONode.Dynamic.getUncached().execute((Object)clazz, this.name);
        if (attribute instanceof PBuiltinFunction && PythonBinaryBuiltinNode.class.isAssignableFrom((builtinFunction = (PBuiltinFunction)attribute).getBuiltinNodeFactory().getNodeClass())) {
            return (PythonBinaryBuiltinNode)((Object)builtinFunction.getBuiltinNodeFactory().createNode(new Object[0]));
        }
        return null;
    }

    protected static PythonBuiltinClassType getBuiltinClass(Node inliningTarget, Object receiver, GetClassNode getClassNode) {
        Object clazz = getClassNode.execute(inliningTarget, receiver);
        return clazz instanceof PythonBuiltinClassType ? (PythonBuiltinClassType)((Object)clazz) : null;
    }

    protected static boolean isClazz(Node inliningTarget, PythonBuiltinClassType clazz, Object receiver, GetClassNode getClassNode) {
        return getClassNode.execute(inliningTarget, receiver) == clazz;
    }

    @Specialization(guards={"clazz != null", "function != null", "isClazz(inliningTarget, clazz, left, getClassNode)"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callObjectBuiltin(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached(value="getBuiltinClass($node, left, getClassNode)") PythonBuiltinClassType clazz, @Cached(value="getBinaryBuiltin(clazz)") PythonBinaryBuiltinNode function) {
        return function.execute(frame, left, right);
    }

    @Specialization(guards={"left.getClass() == cachedLeftClass", "right.getClass() == cachedRightClass"}, limit="5")
    Object callObjectGeneric(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached(value="left.getClass()") Class<?> cachedLeftClass, @Cached(value="right.getClass()") Class<?> cachedRightClass, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached(value="create(name)") LookupSpecialMethodNode getattr) {
        return this.doCallObject(frame, inliningTarget, left, right, getClassNode, getattr);
    }

    @Specialization(replaces={"callObjectGeneric"})
    @ReportPolymorphism.Megamorphic
    Object callObjectMegamorphic(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached(value="create(name)") LookupSpecialMethodNode getattr) {
        return this.doCallObject(frame, inliningTarget, left, right, getClassNode, getattr);
    }

    private Object doCallObject(VirtualFrame frame, Node inliningTarget, Object left, Object right, GetClassNode getClassNode, LookupSpecialMethodNode getattr) {
        Object leftClass = getClassNode.execute(inliningTarget, left);
        Object leftCallable = getattr.execute((Frame)frame, leftClass, left);
        if (PGuards.isNoValue(leftCallable)) {
            throw SpecialMethodNotFound.INSTANCE;
        }
        return this.ensureDispatch().executeObject((Frame)frame, leftCallable, left, right);
    }
}

