/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.modules.io.PTextIOBase;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;

public final class PStringIO
extends PTextIOBase {
    private boolean closed;
    private TruffleString cachedString;
    private TruffleStringBuilder buf = null;
    private TruffleStringBuilder sb;
    private int pos;
    private int stringSize;

    public PStringIO(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    public TruffleStringBuilder getBuf() {
        return this.buf;
    }

    public void setBuf(TruffleStringBuilder buf) {
        this.buf = buf;
        this.cachedString = null;
    }

    public void invalidateBufCache() {
        this.cachedString = null;
    }

    public int getPos() {
        return this.pos;
    }

    public void incPos(int p) {
        this.pos += p;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public void setStringsize(int string_size) {
        this.stringSize = string_size;
    }

    public int getStringSize() {
        return this.stringSize;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void realize() {
        if (!this.isAccumulating()) {
            return;
        }
        this.buf = this.sb;
        this.cachedString = null;
        this.sb = null;
    }

    public boolean isAccumulating() {
        return this.sb != null;
    }

    public void setAccumulating() {
        assert (this.stringSize == 0 && !this.isAccumulating());
        this.sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
        this.cachedString = null;
    }

    public void append(TruffleString str, TruffleStringBuilder.AppendStringNode appendStringNode) {
        assert (this.isAccumulating());
        appendStringNode.execute(this.sb, (AbstractTruffleString)str);
    }

    public void setRealized() {
        this.sb = null;
        this.buf = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
    }

    public TruffleString makeIntermediate(TruffleStringBuilder.ToStringNode toStringNode) {
        assert (this.isAccumulating());
        return toStringNode.execute(this.sb);
    }

    @Override
    public void clearAll() {
        super.clearAll();
        this.buf = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
        this.sb = null;
        this.cachedString = null;
        this.setWriteNewline(null);
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class PStringIOBufToStringNode
    extends Node {
        PStringIOBufToStringNode() {
        }

        abstract TruffleString execute(Node var1, PStringIO var2);

        static boolean hasCache(PStringIO s) {
            return s.cachedString != null;
        }

        @Specialization(guards={"hasCache(self)"})
        TruffleString doCached(PStringIO self) {
            return self.cachedString;
        }

        @Specialization(guards={"!hasCache(self)"})
        TruffleString doUncached(PStringIO self, @Cached(inline=false) TruffleStringBuilder.ToStringNode toStringNode) {
            self.cachedString = toStringNode.execute(self.getBuf());
            return self.cachedString;
        }
    }
}

