/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleType;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class AccessorPrototype {
    private final short formOfUse;
    private final String columnName;
    private final int describeType;
    private final int describeMaxLength;
    private final int describeMaxLengthChars;
    private final boolean nullable;
    private final int precision;
    private final int scale;
    private final OracleType describeOtype;
    private final OracleResultSetMetaData.SecurityAttribute securityAttribute;
    private final boolean columnInvisible;
    private final boolean columnJSON;
    private final int oacmxl;
    private final ByteArray rowData;
    private final long[] rowOffset;
    private final int[] rowLength;
    private final boolean[] rowNull;
    private final byte[] rowMetadata;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    abstract Accessor newAccessor(OracleStatement var1) throws SQLException;

    protected AccessorPrototype(int numRows, Accessor acc, ByteArray stmtRowData) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null, numRows, acc, stmtRowData);
            }
            this.formOfUse = acc.formOfUse;
            this.columnName = acc.columnName;
            this.describeType = acc.describeType;
            this.describeMaxLength = acc.describeMaxLength;
            this.describeMaxLengthChars = acc.describeMaxLengthChars;
            this.nullable = acc.nullable;
            this.precision = acc.precision;
            this.scale = acc.scale;
            this.describeOtype = acc.describeOtype;
            this.securityAttribute = acc.securityAttribute;
            this.columnInvisible = acc.columnInvisible;
            this.columnJSON = acc.columnJSON;
            this.oacmxl = acc.oacmxl;
            if (!$assertionsDisabled && numRows < 0) {
                AssertionError assertionError = new AssertionError((Object)("numRows: " + numRows));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && acc == null) {
                AssertionError assertionError = new AssertionError((Object)"null acc");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && acc.rowOffset == null) {
                AssertionError assertionError = new AssertionError((Object)"null acc.rowOffset");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && acc.rowOffset.length < numRows) {
                AssertionError assertionError = new AssertionError((Object)("accRowOffset.length: " + acc.rowOffset.length + " numRows: " + numRows));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && acc.rowLength == null) {
                AssertionError assertionError = new AssertionError((Object)"null acc.rowLength");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && acc.rowLength.length < numRows) {
                AssertionError assertionError = new AssertionError((Object)("accRowLength.length: " + acc.rowLength.length + " numRows: " + numRows));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && acc.rowNull == null) {
                AssertionError assertionError = new AssertionError((Object)"null acc.rowNull");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && acc.rowNull.length < numRows) {
                AssertionError assertionError = new AssertionError((Object)("accRowNull.length: " + acc.rowLength.length + " numRows: " + numRows));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && acc.rowMetadata == null) {
                AssertionError assertionError = new AssertionError((Object)"null acc.rowMetadata");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && acc.rowMetadata.length < numRows) {
                AssertionError assertionError = new AssertionError((Object)("accRowMetadata.length: " + acc.rowMetadata.length + " numRows: " + numRows));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.rowData = stmtRowData;
            this.rowOffset = Arrays.copyOfRange(acc.rowOffset, 0, numRows);
            this.rowLength = Arrays.copyOfRange(acc.rowLength, 0, numRows);
            this.rowNull = Arrays.copyOfRange(acc.rowNull, 0, numRows);
            this.rowMetadata = Arrays.copyOfRange(acc.rowMetadata, 0, numRows);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void initializeRowData(Accessor accessor) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void acc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$0, this, accessor);
            }
            if (!$assertionsDisabled && acc == null) {
                AssertionError assertionError = new AssertionError((Object)"null acc");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$0, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            acc.columnName = this.columnName;
            acc.rowData = this.rowData;
            acc.rowOffset = this.rowOffset;
            acc.rowLength = this.rowLength;
            acc.rowNull = this.rowNull;
            acc.rowMetadata = this.rowMetadata;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, AccessorPrototype.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$1 = AccessorPrototype.class.getDeclaredConstructor(Integer.TYPE, Accessor.class, ByteArray.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = AccessorPrototype.class.getDeclaredMethod("initializeRowData", Accessor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

