/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;

class SqlTimestampDiffFunction
extends SqlFunction {
    private static RelDataType inferReturnType2(SqlOperatorBinding opBinding) {
        RelDataType type2;
        RelDataType type1;
        TimeUnit timeUnit;
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        if (opBinding.isOperandTimeFrame(0)) {
            timeUnit = opBinding.getOperandLiteralValue(0, TimeUnit.class);
            type1 = opBinding.getOperandType(1);
            type2 = opBinding.getOperandType(2);
        } else {
            type1 = opBinding.getOperandType(0);
            type2 = opBinding.getOperandType(1);
            timeUnit = opBinding.getOperandLiteralValue(2, TimeUnit.class);
        }
        SqlTypeName sqlTypeName = timeUnit == TimeUnit.NANOSECOND ? SqlTypeName.BIGINT : SqlTypeName.INTEGER;
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(sqlTypeName), type1.isNullable() || type2.isNullable());
    }

    SqlTimestampDiffFunction(String name, SqlOperandTypeChecker operandTypeChecker) {
        super(name, SqlKind.TIMESTAMP_DIFF, SqlTimestampDiffFunction::inferReturnType2, null, operandTypeChecker, SqlFunctionCategory.TIMEDATE);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
        if (call.operand(2) instanceof SqlIntervalQualifier) {
            SqlIntervalQualifier op2 = (SqlIntervalQualifier)call.operand(2);
            validator.validateTimeFrame(op2);
            if (op2.timeFrameName == null && op2.timeUnitRange.startUnit.multiplier == null) {
                throw validator.newValidationError(op2, Static.RESOURCE.invalidTimeFrameInOperation(op2.timeUnitRange.toString(), call.getOperator().getName()));
            }
        } else {
            SqlIntervalQualifier op0 = (SqlIntervalQualifier)call.operand(0);
            validator.validateTimeFrame(op0);
            if (op0.timeFrameName == null && op0.timeUnitRange.startUnit.multiplier == null) {
                throw validator.newValidationError(op0, Static.RESOURCE.invalidTimeFrameInOperation(op0.timeUnitRange.toString(), call.getOperator().getName()));
            }
        }
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        RelDataType common;
        SqlValidator validator = callBinding.getValidator();
        SqlCall call = callBinding.getCall();
        int leftIndex = 1;
        int rightIndex = 2;
        if (call.operand(2) instanceof SqlIntervalQualifier) {
            leftIndex = 0;
            rightIndex = 1;
        }
        RelDataType left = callBinding.getOperandType(leftIndex);
        RelDataType right = callBinding.getOperandType(rightIndex);
        if (left.getSqlTypeName() == SqlTypeName.DATE && right.getSqlTypeName() == SqlTypeName.TIME) {
            common = validator.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP);
            common = validator.getTypeFactory().createTypeWithNullability(common, left.isNullable());
            SqlCall castLeft = SqlStdOperatorTable.CAST.createCall(call.getParserPosition(), call.getOperandList().get(leftIndex), SqlTypeUtil.convertTypeToSpec(common).withNullable(common.isNullable()));
            call.setOperand(leftIndex, castLeft);
            validator.setValidatedNodeType(castLeft, common);
        }
        if (right.getSqlTypeName() == SqlTypeName.DATE && left.getSqlTypeName() == SqlTypeName.TIME) {
            common = validator.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP);
            common = validator.getTypeFactory().createTypeWithNullability(common, right.isNullable());
            SqlCall castRight = SqlStdOperatorTable.CAST.createCall(call.getParserPosition(), call.getOperandList().get(rightIndex), SqlTypeUtil.convertTypeToSpec(common).withNullable(common.isNullable()));
            call.setOperand(rightIndex, castRight);
            validator.setValidatedNodeType(castRight, common);
        }
        return super.checkOperandTypes(callBinding, throwOnFailure);
    }
}

