/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.x509.dn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.cryptacular.CryptUtil;
import org.cryptacular.x509.dn.Attribute;
import org.cryptacular.x509.dn.AttributeType;

public class Attributes
implements Iterable<Attribute> {
    private final List<Attribute> attributes = new ArrayList<Attribute>(5);

    public Attributes(Attribute ... attributes) {
        this(Arrays.asList(attributes));
    }

    public Attributes(List<Attribute> attributes) {
        this.attributes.addAll(CryptUtil.assertNotNullArgOr(attributes, v -> v.stream().anyMatch(Objects::isNull), "Attributes cannot be null"));
    }

    public int size() {
        return this.attributes.size();
    }

    public List<Attribute> getAll() {
        return Collections.unmodifiableList(this.attributes);
    }

    public List<String> getValues(AttributeType type) {
        ArrayList values = new ArrayList(this.attributes.size());
        values.addAll(this.attributes.stream().filter(attr -> attr.getType().equals(type)).map(Attribute::getValue).collect(Collectors.toList()));
        return Collections.unmodifiableList(values);
    }

    public String getValue(AttributeType type) {
        for (Attribute attr : this.attributes) {
            if (!attr.getType().equals(type)) continue;
            return attr.getValue();
        }
        return null;
    }

    @Override
    public Iterator<Attribute> iterator() {
        return this.attributes.iterator();
    }
}

