/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.model;

import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.observability.model.BaseModel;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 5*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u000245B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007B7\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\u0004\b\u0006\u0010\u000fB/\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\t\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0015B\u0019\b\u0016\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0018B\u001f\b\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c\u00a2\u0006\u0004\b\u0006\u0010\u001dJ\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J!\u0010(\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0004H&\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u001c\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001002\b\u00102\u001a\u0004\u0018\u000103H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00066"}, d2={"Lorg/opensearch/observability/model/SearchResults;", "ItemClass", "Lorg/opensearch/observability/model/BaseModel;", "objectListFieldName", "", "objectItem", "<init>", "(Ljava/lang/String;Lorg/opensearch/observability/model/BaseModel;)V", "startIndex", "", "totalHits", "totalHitRelation", "Lorg/apache/lucene/search/TotalHits$Relation;", "objectList", "", "(JJLorg/apache/lucene/search/TotalHits$Relation;Ljava/lang/String;Ljava/util/List;)V", "from", "response", "Lorg/opensearch/action/search/SearchResponse;", "searchHitParser", "Lorg/opensearch/observability/model/SearchResults$SearchHitParser;", "(JLorg/opensearch/action/search/SearchResponse;Lorg/opensearch/observability/model/SearchResults$SearchHitParser;Ljava/lang/String;)V", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "(Lorg/opensearch/core/xcontent/XContentParser;Ljava/lang/String;)V", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "reader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "(Lorg/opensearch/core/common/io/stream/StreamInput;Lorg/opensearch/core/common/io/stream/Writeable$Reader;)V", "getStartIndex", "()J", "getTotalHits", "getTotalHitRelation", "()Lorg/apache/lucene/search/TotalHits$Relation;", "getObjectListFieldName", "()Ljava/lang/String;", "getObjectList", "()Ljava/util/List;", "parseItemList", "parseItem", "useId", "(Lorg/opensearch/core/xcontent/XContentParser;Ljava/lang/String;)Lorg/opensearch/observability/model/BaseModel;", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "SearchHitParser", "Companion", "opensearch-observability"})
@SourceDebugExtension(value={"SMAP\nSearchResults.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchResults.kt\norg/opensearch/observability/model/SearchResults\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1869#2,2:219\n1869#2,2:221\n*S KotlinDebug\n*F\n+ 1 SearchResults.kt\norg/opensearch/observability/model/SearchResults\n*L\n86#1:219,2\n214#1:221,2\n*E\n"})
public abstract class SearchResults<ItemClass extends BaseModel>
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long startIndex;
    private final long totalHits;
    @NotNull
    private final TotalHits.Relation totalHitRelation;
    @NotNull
    private final String objectListFieldName;
    @NotNull
    private final List<ItemClass> objectList;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(SearchResults.class);
    @NotNull
    private static final String START_INDEX_TAG = "startIndex";
    @NotNull
    private static final String TOTAL_HITS_TAG = "totalHits";
    @NotNull
    private static final String TOTAL_HIT_RELATION_TAG = "totalHitRelation";

    public final long getStartIndex() {
        return this.startIndex;
    }

    public final long getTotalHits() {
        return this.totalHits;
    }

    @NotNull
    public final TotalHits.Relation getTotalHitRelation() {
        return this.totalHitRelation;
    }

    @NotNull
    public final String getObjectListFieldName() {
        return this.objectListFieldName;
    }

    @NotNull
    public final List<ItemClass> getObjectList() {
        return this.objectList;
    }

    public SearchResults(@NotNull String objectListFieldName, @NotNull ItemClass objectItem) {
        Intrinsics.checkNotNullParameter((Object)objectListFieldName, (String)"objectListFieldName");
        Intrinsics.checkNotNullParameter(objectItem, (String)"objectItem");
        this.startIndex = 0L;
        this.totalHits = 1L;
        this.totalHitRelation = TotalHits.Relation.EQUAL_TO;
        this.objectListFieldName = objectListFieldName;
        this.objectList = CollectionsKt.listOf(objectItem);
    }

    public SearchResults(long startIndex, long totalHits, @NotNull TotalHits.Relation totalHitRelation, @NotNull String objectListFieldName, @NotNull List<? extends ItemClass> objectList) {
        Intrinsics.checkNotNullParameter((Object)totalHitRelation, (String)TOTAL_HIT_RELATION_TAG);
        Intrinsics.checkNotNullParameter((Object)objectListFieldName, (String)"objectListFieldName");
        Intrinsics.checkNotNullParameter(objectList, (String)"objectList");
        this.startIndex = startIndex;
        this.totalHits = totalHits;
        this.totalHitRelation = totalHitRelation;
        this.objectListFieldName = objectListFieldName;
        this.objectList = objectList;
    }

    public SearchResults(long from, @NotNull SearchResponse response, @NotNull SearchHitParser<ItemClass> searchHitParser2, @NotNull String objectListFieldName) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(searchHitParser2, (String)"searchHitParser");
        Intrinsics.checkNotNullParameter((Object)objectListFieldName, (String)"objectListFieldName");
        List mutableList = new ArrayList();
        SearchHits searchHits = response.getHits();
        Intrinsics.checkNotNullExpressionValue((Object)searchHits, (String)"getHits(...)");
        Iterable $this$forEach$iv = (Iterable)searchHits;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SearchHit it = (SearchHit)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            mutableList.add(searchHitParser2.parse(it));
        }
        TotalHits totalHits = response.getHits().getTotalHits();
        long totalHitsVal = 0L;
        TotalHits.Relation totalHitsRelation = null;
        if (totalHits == null) {
            totalHitsVal = mutableList.size();
            totalHitsRelation = TotalHits.Relation.EQUAL_TO;
        } else {
            totalHitsVal = totalHits.value();
            TotalHits.Relation relation = totalHits.relation();
            Intrinsics.checkNotNullExpressionValue((Object)relation, (String)"relation(...)");
            totalHitsRelation = relation;
        }
        this.startIndex = from;
        this.totalHits = totalHitsVal;
        this.totalHitRelation = totalHitsRelation;
        this.objectListFieldName = objectListFieldName;
        this.objectList = mutableList;
    }

    public SearchResults(@NotNull XContentParser parser, @NotNull String objectListFieldName) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)objectListFieldName, (String)"objectListFieldName");
        long startIndex = 0L;
        long totalHits = 0L;
        TotalHits.Relation totalHitRelation = TotalHits.Relation.EQUAL_TO;
        List<ItemClass> objectList = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
            String fieldName = parser.currentName();
            parser.nextToken();
            String string = fieldName;
            if (Intrinsics.areEqual((Object)string, (Object)START_INDEX_TAG)) {
                startIndex = parser.longValue();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)TOTAL_HITS_TAG)) {
                totalHits = parser.longValue();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)TOTAL_HIT_RELATION_TAG)) {
                String string2 = parser.text();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text(...)");
                totalHitRelation = SearchResults.Companion.convertRelation(string2);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)objectListFieldName)) {
                objectList = this.parseItemList(parser);
                continue;
            }
            parser.skipChildren();
            SearchResults.Companion.getLog().info("Skipping Unknown field " + fieldName);
        }
        if (objectList == null) {
            throw new IllegalArgumentException(objectListFieldName + " field absent");
        }
        if (totalHits == 0L) {
            totalHits = objectList.size();
        }
        this.startIndex = startIndex;
        this.totalHits = totalHits;
        this.totalHitRelation = totalHitRelation;
        this.objectListFieldName = objectListFieldName;
        this.objectList = objectList;
    }

    private final List<ItemClass> parseItemList(XContentParser parser) {
        List retList = new ArrayList();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            retList.add(SearchResults.parseItem$default(this, parser, null, 2, null));
        }
        return retList;
    }

    @NotNull
    public abstract ItemClass parseItem(@NotNull XContentParser var1, @Nullable String var2);

    public static /* synthetic */ BaseModel parseItem$default(SearchResults searchResults, XContentParser xContentParser, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parseItem");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return searchResults.parseItem(xContentParser, string);
    }

    public SearchResults(@NotNull StreamInput input, @NotNull Writeable.Reader<ItemClass> reader) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        long l = input.readLong();
        long l2 = input.readLong();
        Enum enum_ = input.readEnum(TotalHits.Relation.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        TotalHits.Relation relation = (TotalHits.Relation)enum_;
        String string = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        List list = input.readList(reader);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
        this(l, l2, relation, string, list);
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeLong(this.startIndex);
        output.writeLong(this.totalHits);
        output.writeEnum((Enum)this.totalHitRelation);
        output.writeString(this.objectListFieldName);
        output.writeList(this.objectList);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        XContentBuilder xContentBuilder = builder;
        Intrinsics.checkNotNull((Object)xContentBuilder);
        xContentBuilder.startObject().field(START_INDEX_TAG, this.startIndex).field(TOTAL_HITS_TAG, this.totalHits).field(TOTAL_HIT_RELATION_TAG, SearchResults.Companion.convertRelation(this.totalHitRelation)).startArray(this.objectListFieldName);
        Iterable $this$forEach$iv = this.objectList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseModel it = (BaseModel)element$iv;
            boolean bl = false;
            ((ToXContent)it).toXContent(builder, params);
        }
        XContentBuilder xContentBuilder2 = builder.endArray().endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"endObject(...)");
        return xContentBuilder2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u000e\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/observability/model/SearchResults$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "START_INDEX_TAG", "", "TOTAL_HITS_TAG", "TOTAL_HIT_RELATION_TAG", "convertRelation", "totalHitRelation", "Lorg/apache/lucene/search/TotalHits$Relation;", "opensearch-observability"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        private final String convertRelation(TotalHits.Relation totalHitRelation) {
            return totalHitRelation == TotalHits.Relation.EQUAL_TO ? "eq" : "gte";
        }

        private final TotalHits.Relation convertRelation(String totalHitRelation) {
            return Intrinsics.areEqual((Object)totalHitRelation, (Object)"eq") ? TotalHits.Relation.EQUAL_TO : TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00012\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lorg/opensearch/observability/model/SearchResults$SearchHitParser;", "ItemClass", "", "parse", "searchHit", "Lorg/opensearch/search/SearchHit;", "(Lorg/opensearch/search/SearchHit;)Ljava/lang/Object;", "opensearch-observability"})
    public static interface SearchHitParser<ItemClass> {
        public ItemClass parse(@NotNull SearchHit var1);
    }
}

