/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.fips.FipsKDF;

class AEADUtil {
    AEADUtil() {
    }

    static byte[] deriveMessageKeyAndIv(int aeadAlgo, int cipherAlgo, byte[] sessionKey, byte[] salt, byte[] hkdfInfo) {
        FipsKDF.AgreementOperatorFactory kdfOpt = new FipsKDF.AgreementOperatorFactory();
        FipsKDF.HKDFKey key = FipsKDF.HKDF_KEY_BUILDER.withPrf(FipsKDF.AgreementKDFPRF.SHA256_HMAC).withSalt(salt).build(sessionKey);
        KDFCalculator kdfCalculator = kdfOpt.createKDFCalculator((Parameters)FipsKDF.HKDF.withPRF(key.getPRF()).using(key.getKey()).withIV(hkdfInfo));
        int keyLen = SymmetricKeyUtils.getKeyLengthInOctets(cipherAlgo);
        int ivLen = AEADUtils.getIVLength(aeadAlgo);
        byte[] messageKeyAndIv = new byte[keyLen + ivLen - 8];
        kdfCalculator.generateBytes(messageKeyAndIv, 0, messageKeyAndIv.length);
        return messageKeyAndIv;
    }
}

