/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.Filter;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.FilterConfiguration;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.Restrictable;
import org.hibernate.persister.entity.EntityNameUse;
import org.hibernate.sql.Template;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class FilterHelper {
    private static final Pattern FILTER_PARAMETER_PATTERN = Pattern.compile(":((\\S+)(\\w+))");
    private final String[] filterNames;
    private final String[] filterConditions;
    private final boolean[] filterAutoAliasFlags;
    private final Map<String, String>[] filterAliasTableMaps;
    private final List<String>[] parameterNames;
    private final Map<String, String> tableToEntityName;

    public FilterHelper(List<FilterConfiguration> filters, SessionFactoryImplementor factory) {
        this(filters, null, factory);
    }

    public FilterHelper(List<FilterConfiguration> filters, Map<String, String> tableToEntityName, SessionFactoryImplementor factory) {
        int filterCount = filters.size();
        this.filterNames = new String[filterCount];
        this.filterConditions = new String[filterCount];
        this.filterAutoAliasFlags = new boolean[filterCount];
        this.filterAliasTableMaps = new Map[filterCount];
        this.parameterNames = new List[filterCount];
        this.tableToEntityName = tableToEntityName;
        filterCount = 0;
        for (FilterConfiguration filter : filters) {
            String filterName;
            this.filterNames[filterCount] = filterName = StringHelper.safeInterning(filter.getName());
            this.filterConditions[filterCount] = StringHelper.safeInterning(filter.getCondition());
            this.filterAliasTableMaps[filterCount] = filter.getAliasTableMap(factory);
            this.filterAutoAliasFlags[filterCount] = false;
            this.injectAliases(factory, filter, filterCount);
            this.qualifyParameterNames(filterCount, filterName);
            ++filterCount;
        }
    }

    private void injectAliases(SessionFactoryImplementor factory, FilterConfiguration filter, int filterCount) {
        if ((this.filterAliasTableMaps[filterCount].isEmpty() || FilterHelper.isTableFromPersistentClass(this.filterAliasTableMaps[filterCount])) && filter.useAutoAliasInjection()) {
            String autoAliasedCondition = Template.renderWhereStringTemplate(filter.getCondition(), "$FILTER_PLACEHOLDER$", factory.getJdbcServices().getDialect(), factory.getTypeConfiguration());
            this.filterConditions[filterCount] = StringHelper.safeInterning(autoAliasedCondition);
            this.filterAutoAliasFlags[filterCount] = true;
        }
    }

    private void qualifyParameterNames(int filterCount, String filterName) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        boolean foundAny = false;
        Matcher matcher = FILTER_PARAMETER_PATTERN.matcher(this.filterConditions[filterCount]);
        while (matcher.find()) {
            parameterNames.add(matcher.group(1));
            foundAny = true;
        }
        if (foundAny) {
            this.filterConditions[filterCount] = StringHelper.safeInterning(matcher.replaceAll(":" + filterName + ".$1"));
        }
        this.parameterNames[filterCount] = parameterNames;
    }

    private static boolean isTableFromPersistentClass(Map<String, String> aliasTableMap) {
        return aliasTableMap.size() == 1 && aliasTableMap.containsKey(null);
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public boolean isAffectedBy(Map<String, Filter> enabledFilters) {
        return this.isAffectedBy(enabledFilters, false);
    }

    public boolean isAffectedBy(Map<String, Filter> enabledFilters, boolean onlyApplyForLoadByKey) {
        for (String filterName : this.filterNames) {
            Filter filter = enabledFilters.get(filterName);
            if (filter == null || onlyApplyForLoadByKey && !filter.isAppliedToLoadByKey()) continue;
            return true;
        }
        return false;
    }

    public static void applyBaseRestrictions(Consumer<Predicate> predicateConsumer, Restrictable restrictable, TableGroup rootTableGroup, boolean useIdentificationVariable, LoadQueryInfluencers loadQueryInfluencers, SqlAstCreationState astCreationState) {
        restrictable.applyBaseRestrictions(predicateConsumer, rootTableGroup, useIdentificationVariable, loadQueryInfluencers.getEnabledFilters(), astCreationState.applyOnlyLoadByKeyFilters(), null, astCreationState);
    }

    public void applyEnabledFilters(Consumer<Predicate> predicateConsumer, FilterAliasGenerator aliasGenerator, Map<String, Filter> enabledFilters, boolean onlyApplyLoadByKeyFilters, TableGroup tableGroup, SqlAstCreationState creationState) {
        FilterPredicate predicate = this.generateFilterPredicate(aliasGenerator, enabledFilters, onlyApplyLoadByKeyFilters, tableGroup, creationState);
        if (predicate != null) {
            predicateConsumer.accept(predicate);
        }
    }

    private FilterPredicate generateFilterPredicate(FilterAliasGenerator aliasGenerator, Map<String, Filter> enabledFilters, boolean onlyApplyLoadByKeyFilters, TableGroup tableGroup, SqlAstCreationState creationState) {
        FilterPredicate filterPredicate = new FilterPredicate();
        int max = this.filterNames.length;
        for (int i = 0; i < max; ++i) {
            Filter enabledFilter = enabledFilters.get(this.filterNames[i]);
            if (enabledFilter == null || onlyApplyLoadByKeyFilters && !enabledFilter.isAppliedToLoadByKey()) continue;
            filterPredicate.applyFragment(this.render(aliasGenerator, i, tableGroup, creationState), enabledFilter, this.parameterNames[i]);
        }
        if (filterPredicate.isEmpty()) {
            return null;
        }
        return filterPredicate;
    }

    public String render(FilterAliasGenerator aliasGenerator, Map<String, Filter> enabledFilters) {
        StringBuilder buffer = new StringBuilder();
        this.render(buffer, aliasGenerator, enabledFilters);
        return buffer.toString();
    }

    public void render(StringBuilder buffer, FilterAliasGenerator aliasGenerator, Map<String, Filter> enabledFilters) {
        if (CollectionHelper.isNotEmpty(this.filterNames)) {
            int max = this.filterNames.length;
            for (int i = 0; i < max; ++i) {
                if (!enabledFilters.containsKey(this.filterNames[i]) || !StringHelper.isNotEmpty(this.filterConditions[i])) continue;
                if (!buffer.isEmpty()) {
                    buffer.append(" and ");
                }
                buffer.append(this.render(aliasGenerator, i, null, null));
            }
        }
    }

    private String render(FilterAliasGenerator aliasGenerator, int filterIndex, TableGroup tableGroup, SqlAstCreationState creationState) {
        String condition = this.filterConditions[filterIndex];
        if (aliasGenerator == null) {
            return StringHelper.replace(condition, "$FILTER_PLACEHOLDER$.", "");
        }
        Map<String, String> aliasTableMap = this.filterAliasTableMaps[filterIndex];
        if (this.filterAutoAliasFlags[filterIndex]) {
            String tableName = aliasTableMap.get(null);
            return this.replaceMarker(tableGroup, creationState, condition, aliasGenerator.getAlias(tableName), FilterHelper.tableName(tableGroup, tableName));
        }
        if (FilterHelper.isTableFromPersistentClass(aliasTableMap)) {
            String tableName = aliasTableMap.get(null);
            return this.replaceAlias(tableGroup, creationState, condition, "{alias}", aliasGenerator.getAlias(tableName), FilterHelper.tableName(tableGroup, tableName));
        }
        String newCondition = condition;
        for (Map.Entry<String, String> entry : aliasTableMap.entrySet()) {
            String tableName = entry.getValue();
            newCondition = this.replaceAlias(tableGroup, creationState, newCondition, "{" + entry.getKey() + "}", aliasGenerator.getAlias(tableName), tableName);
        }
        return newCondition;
    }

    private String replaceMarker(TableGroup tableGroup, SqlAstCreationState creationState, String condition, String alias, String tableName) {
        String newCondition = StringHelper.replace(condition, "$FILTER_PLACEHOLDER$", alias);
        if (creationState != null && this.tableToEntityName != null && !newCondition.equals(condition)) {
            this.registerEntityNameUsage(tableGroup, creationState, tableName);
        }
        return newCondition;
    }

    private String replaceAlias(TableGroup tableGroup, SqlAstCreationState creationState, String condition, String placeholder, String alias, String tableName) {
        String newCondition = StringHelper.replace(condition, placeholder, alias);
        if (creationState != null && !newCondition.equals(condition)) {
            this.registerEntityNameUsage(tableGroup, creationState, tableName);
        }
        return newCondition;
    }

    private void registerEntityNameUsage(TableGroup tableGroup, SqlAstCreationState creationState, String tableName) {
        creationState.registerEntityNameUsage(tableGroup, EntityNameUse.EXPRESSION, this.tableToEntityName.get(tableName));
    }

    private static String tableName(TableGroup tableGroup, String tableName) {
        return tableName == null ? tableGroup.getPrimaryTableReference().getTableId() : tableName;
    }
}

