/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.impl.activator.NullCommandActivator;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.result.NullResultHandler;
import org.aesh.command.impl.validator.NullCommandValidator;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.populator.CommandPopulator;
import org.aesh.command.result.ResultHandler;
import org.aesh.command.validator.CommandValidator;
import org.aesh.util.ReflectionUtil;

public class ProcessedCommandBuilder<C extends Command<CI>, CI extends CommandInvocation> {
    private String name;
    private String description;
    private CommandValidator<C, CI> validator;
    private ResultHandler resultHandler;
    private ProcessedOption arguments;
    private ProcessedOption arg;
    private final List<ProcessedOption> options = new ArrayList<ProcessedOption>();
    private CommandPopulator<Object, CI> populator;
    private C command;
    private List<String> aliases;
    private CommandActivator activator;
    private boolean generateHelp;
    private boolean disableParsing;
    private String version;

    private ProcessedCommandBuilder() {
    }

    public static <T extends Command<I>, I extends CommandInvocation> ProcessedCommandBuilder<T, I> builder() {
        return new ProcessedCommandBuilder();
    }

    public ProcessedCommandBuilder<C, CI> name(String name) {
        this.name = name;
        return this;
    }

    public ProcessedCommandBuilder<C, CI> aliases(List<String> aliases) {
        this.aliases = aliases == null ? Collections.emptyList() : Collections.unmodifiableList(aliases);
        return this;
    }

    public ProcessedCommandBuilder<C, CI> description(String usage) {
        this.description = usage;
        return this;
    }

    public ProcessedCommandBuilder<C, CI> version(String version) {
        this.version = version;
        return this;
    }

    public ProcessedCommandBuilder<C, CI> generateHelp(boolean help) {
        this.generateHelp = help;
        return this;
    }

    public ProcessedCommandBuilder<C, CI> disableParsing(boolean disableParsing) {
        this.disableParsing = disableParsing;
        return this;
    }

    public ProcessedCommandBuilder<C, CI> arguments(ProcessedOption arguments) {
        this.arguments = arguments;
        return this;
    }

    public ProcessedCommandBuilder<C, CI> argument(ProcessedOption argument) {
        this.arg = argument;
        return this;
    }

    public ProcessedCommandBuilder<C, CI> validator(CommandValidator<C, CI> validator) {
        this.validator = validator;
        return this;
    }

    public ProcessedCommandBuilder<C, CI> validator(Class<? extends CommandValidator<C, CI>> validator) {
        this.validator = this.initValidator(validator);
        return this;
    }

    private CommandValidator<C, CI> initValidator(Class<? extends CommandValidator<C, CI>> validator) {
        if (validator != null && !validator.equals(NullCommandValidator.class)) {
            return ReflectionUtil.newInstance(validator);
        }
        return new NullCommandValidator();
    }

    public ProcessedCommandBuilder<C, CI> resultHandler(Class<? extends ResultHandler> resultHandler) {
        this.resultHandler = this.initResultHandler(resultHandler);
        return this;
    }

    private ResultHandler initResultHandler(Class<? extends ResultHandler> resultHandler) {
        if (resultHandler != null && !resultHandler.equals(NullResultHandler.class)) {
            return ReflectionUtil.newInstance(resultHandler);
        }
        return new NullResultHandler();
    }

    public ProcessedCommandBuilder<C, CI> resultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
        return this;
    }

    public ProcessedCommandBuilder<C, CI> populator(CommandPopulator<Object, CI> populator) {
        this.populator = populator;
        return this;
    }

    public ProcessedCommandBuilder<C, CI> activator(CommandActivator activator) {
        this.activator = activator;
        return this;
    }

    public ProcessedCommandBuilder<C, CI> activator(Class<? extends CommandActivator> activator) {
        this.activator = this.initActivator(activator);
        return this;
    }

    private CommandActivator initActivator(Class<? extends CommandActivator> activator) {
        if (activator != null && activator != NullCommandActivator.class) {
            return ReflectionUtil.newInstance(activator);
        }
        return new NullCommandActivator();
    }

    public ProcessedCommandBuilder<C, CI> command(C command) {
        this.command = command;
        return this;
    }

    public ProcessedCommandBuilder<C, CI> command(Class command) {
        this.command = (Command)ReflectionUtil.newInstance(command);
        return this;
    }

    public ProcessedCommandBuilder<C, CI> addOption(ProcessedOption option) {
        this.options.add(option);
        return this;
    }

    public ProcessedCommandBuilder<C, CI> addOptions(List<ProcessedOption> options) {
        if (options != null) {
            this.options.addAll(options);
        }
        return this;
    }

    public ProcessedCommand<C, CI> create() throws CommandLineParserException {
        if (this.name == null || this.name.length() < 1) {
            throw new CommandLineParserException("The parameter name must be defined");
        }
        if (this.validator == null) {
            this.validator = new NullCommandValidator();
        }
        if (this.resultHandler == null) {
            this.resultHandler = new NullResultHandler();
        }
        return new ProcessedCommand<C, CI>(this.name, this.aliases, this.command, this.description, this.validator, this.resultHandler, this.generateHelp, this.disableParsing, this.version, this.arguments, this.options, this.arg, this.populator, this.activator);
    }
}

