/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.wrapper;

import io.agroal.pool.util.AutoCloseableElement;
import io.agroal.pool.wrapper.ConnectionWrapper;
import io.agroal.pool.wrapper.StatementWrapper;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public final class PreparedStatementWrapper
extends StatementWrapper
implements PreparedStatement {
    static final String CLOSED_PREPARED_STATEMENT_STRING = PreparedStatementWrapper.class.getSimpleName() + ".CLOSED_STATEMENT";
    private static final InvocationHandler CLOSED_HANDLER = new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "close": {
                    return Void.TYPE;
                }
                case "isClosed": {
                    return Boolean.TRUE;
                }
                case "toString": {
                    return CLOSED_PREPARED_STATEMENT_STRING;
                }
            }
            throw new SQLException("CallableStatement is closed");
        }
    };
    private static final PreparedStatement CLOSED_STATEMENT = (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, CLOSED_HANDLER);
    private PreparedStatement wrappedStatement;

    public PreparedStatementWrapper(ConnectionWrapper connectionWrapper, PreparedStatement statement, boolean trackJdbcResources, AutoCloseableElement head) {
        super(connectionWrapper, statement, trackJdbcResources, head);
        this.wrappedStatement = statement;
    }

    @Override
    public void close() throws SQLException {
        this.wrappedStatement = CLOSED_STATEMENT;
        super.close();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            return this.trackResultSet(this.wrappedStatement.executeQuery());
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            return this.wrappedStatement.executeUpdate();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this.wrappedStatement.setNull(parameterIndex, sqlType);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            this.wrappedStatement.setBoolean(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            this.wrappedStatement.setByte(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            this.wrappedStatement.setShort(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            this.wrappedStatement.setInt(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            this.wrappedStatement.setLong(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            this.wrappedStatement.setFloat(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            this.wrappedStatement.setDouble(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            this.wrappedStatement.setBigDecimal(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            this.wrappedStatement.setString(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            this.wrappedStatement.setBytes(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            this.wrappedStatement.setDate(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            this.wrappedStatement.setTime(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            this.wrappedStatement.setTimestamp(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.wrappedStatement.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.wrappedStatement.setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.wrappedStatement.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.wrappedStatement.clearParameters();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            this.wrappedStatement.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            this.wrappedStatement.setObject(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            return this.wrappedStatement.execute();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            this.wrappedStatement.addBatch();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            this.wrappedStatement.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        try {
            this.wrappedStatement.setRef(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        try {
            this.wrappedStatement.setBlob(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        try {
            this.wrappedStatement.setClob(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        try {
            this.wrappedStatement.setArray(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.wrappedStatement.getMetaData();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        try {
            this.wrappedStatement.setDate(parameterIndex, x, cal);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        try {
            this.wrappedStatement.setTime(parameterIndex, x, cal);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        try {
            this.wrappedStatement.setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            this.wrappedStatement.setNull(parameterIndex, sqlType, typeName);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        try {
            this.wrappedStatement.setURL(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.wrappedStatement.getParameterMetaData();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        try {
            this.wrappedStatement.setRowId(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        try {
            this.wrappedStatement.setNString(parameterIndex, value);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        try {
            this.wrappedStatement.setNCharacterStream(parameterIndex, value, length);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        try {
            this.wrappedStatement.setNClob(parameterIndex, value);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            this.wrappedStatement.setClob(parameterIndex, reader, length);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        try {
            this.wrappedStatement.setBlob(parameterIndex, inputStream, length);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            this.wrappedStatement.setNClob(parameterIndex, reader, length);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        try {
            this.wrappedStatement.setSQLXML(parameterIndex, xmlObject);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        try {
            this.wrappedStatement.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            this.wrappedStatement.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            this.wrappedStatement.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            this.wrappedStatement.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this.wrappedStatement.setAsciiStream(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this.wrappedStatement.setBinaryStream(parameterIndex, x);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        try {
            this.wrappedStatement.setCharacterStream(parameterIndex, reader);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        try {
            this.wrappedStatement.setNCharacterStream(parameterIndex, value);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        try {
            this.wrappedStatement.setClob(parameterIndex, reader);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        try {
            this.wrappedStatement.setBlob(parameterIndex, inputStream);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        try {
            this.wrappedStatement.setNClob(parameterIndex, reader);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            this.wrappedStatement.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        try {
            this.wrappedStatement.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        try {
            return this.wrappedStatement.executeLargeUpdate();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }
}

