/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.cache;

import java.io.Serializable;
import java.util.function.Function;
import org.hibernate.internal.util.cache.InternalCache;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;

final class LegacyInternalCacheImplementation<K, V>
implements InternalCache<K, V>,
Serializable {
    private final BoundedConcurrentHashMap<K, V> map;

    public LegacyInternalCacheImplementation(int intendedApproximateSize) {
        this.map = new BoundedConcurrentHashMap(intendedApproximateSize, 20, BoundedConcurrentHashMap.Eviction.LIRS);
    }

    @Override
    public int heldElementsEstimate() {
        return this.map.size();
    }

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.map.put(key, value);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.map.computeIfAbsent((K)key, mappingFunction);
    }
}

