/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.PseudoInstruction;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.impl.AbstractElement;
import io.github.dmlloyd.classfile.impl.BufWriterImpl;
import io.github.dmlloyd.classfile.impl.BytecodeHelpers;
import io.github.dmlloyd.classfile.impl.DirectCodeBuilder;
import io.github.dmlloyd.classfile.impl.LabelContext;
import io.github.dmlloyd.classfile.impl.Util;
import io.github.dmlloyd.classfile.instruction.CharacterRange;
import io.github.dmlloyd.classfile.instruction.ExceptionCatch;
import io.github.dmlloyd.classfile.instruction.LocalVariable;
import io.github.dmlloyd.classfile.instruction.LocalVariableType;
import java.util.Objects;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractPseudoInstruction
extends AbstractElement
implements PseudoInstruction {
    @Override
    public abstract void writeTo(DirectCodeBuilder var1);

    public static final class UnboundLocalVariableType
    extends AbstractLocalPseudo
    implements LocalVariableType {
        public UnboundLocalVariableType(int slot, Utf8Entry name, Utf8Entry signature, Label startScope, Label endScope) {
            super(slot, name, signature, startScope, endScope);
        }

        @Override
        public Utf8Entry signature() {
            return this.descriptor;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.addLocalVariableType(this);
        }

        public String toString() {
            return "LocalVariableType[Slot=" + this.slot() + ", name=" + this.nameString() + ", signature='" + this.signature().stringValue() + "']";
        }
    }

    public static final class UnboundLocalVariable
    extends AbstractLocalPseudo
    implements LocalVariable {
        public UnboundLocalVariable(int slot, Utf8Entry name, Utf8Entry descriptor, Label startScope, Label endScope) {
            super(slot, name, descriptor, startScope, endScope);
        }

        @Override
        public Utf8Entry type() {
            return this.descriptor;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.addLocalVariable(this);
        }

        public String toString() {
            return "LocalVariable[Slot=" + this.slot() + ", name=" + this.nameString() + ", descriptor='" + this.type().stringValue() + "']";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class AbstractLocalPseudo
    extends AbstractPseudoInstruction
    implements Util.WritableLocalVariable {
        protected final int slot;
        protected final Utf8Entry name;
        protected final Utf8Entry descriptor;
        protected final Label startScope;
        protected final Label endScope;

        public AbstractLocalPseudo(int slot, Utf8Entry name, Utf8Entry descriptor, Label startScope, Label endScope) {
            BytecodeHelpers.validateSlot(slot);
            this.slot = slot;
            this.name = Objects.requireNonNull(name);
            this.descriptor = Objects.requireNonNull(descriptor);
            this.startScope = Objects.requireNonNull(startScope);
            this.endScope = Objects.requireNonNull(endScope);
        }

        public int slot() {
            return this.slot;
        }

        public Utf8Entry name() {
            return this.name;
        }

        public String nameString() {
            return this.name.stringValue();
        }

        public Label startScope() {
            return this.startScope;
        }

        public Label endScope() {
            return this.endScope;
        }

        @Override
        public boolean writeLocalTo(BufWriterImpl b) {
            LabelContext lc = b.labelContext();
            int startBci = lc.labelToBci(this.startScope());
            int endBci = lc.labelToBci(this.endScope());
            if (startBci == -1 || endBci == -1) {
                return false;
            }
            int length = endBci - startBci;
            b.writeU2U2(startBci, length);
            b.writeU2U2U2(b.cpIndex(this.name), b.cpIndex(this.descriptor), this.slot());
            return true;
        }
    }

    public static final class UnboundCharacterRange
    extends AbstractPseudoInstruction
    implements CharacterRange {
        public final Label startScope;
        public final Label endScope;
        public final int characterRangeStart;
        public final int characterRangeEnd;
        public final int flags;

        public UnboundCharacterRange(Label startScope, Label endScope, int characterRangeStart, int characterRangeEnd, int flags) {
            this.startScope = Objects.requireNonNull(startScope);
            this.endScope = Objects.requireNonNull(endScope);
            this.characterRangeStart = characterRangeStart;
            this.characterRangeEnd = characterRangeEnd;
            this.flags = flags;
        }

        @Override
        public Label startScope() {
            return this.startScope;
        }

        @Override
        public Label endScope() {
            return this.endScope;
        }

        @Override
        public int characterRangeStart() {
            return this.characterRangeStart;
        }

        @Override
        public int characterRangeEnd() {
            return this.characterRangeEnd;
        }

        @Override
        public int flags() {
            return this.flags;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.addCharacterRange(this);
        }
    }

    public static final class ExceptionCatchImpl
    extends AbstractPseudoInstruction
    implements ExceptionCatch {
        public final ClassEntry catchTypeEntry;
        public final Label handler;
        public final Label tryStart;
        public final Label tryEnd;

        public ExceptionCatchImpl(Label handler, Label tryStart, Label tryEnd, ClassEntry catchTypeEntry) {
            this.catchTypeEntry = catchTypeEntry;
            this.handler = Objects.requireNonNull(handler);
            this.tryStart = Objects.requireNonNull(tryStart);
            this.tryEnd = Objects.requireNonNull(tryEnd);
        }

        public ExceptionCatchImpl(Label handler, Label tryStart, Label tryEnd, Optional<ClassEntry> catchTypeEntry) {
            this(handler, tryStart, tryEnd, (ClassEntry)catchTypeEntry.orElse(null));
        }

        @Override
        public Label tryStart() {
            return this.tryStart;
        }

        @Override
        public Label handler() {
            return this.handler;
        }

        @Override
        public Label tryEnd() {
            return this.tryEnd;
        }

        @Override
        public Optional<ClassEntry> catchType() {
            return Optional.ofNullable(this.catchTypeEntry);
        }

        ClassEntry catchTypeEntry() {
            return this.catchTypeEntry;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.addHandler(this);
        }

        public String toString() {
            return String.format("ExceptionCatch[catchType=%s]", this.catchTypeEntry == null ? "<any>" : this.catchTypeEntry.name().stringValue());
        }
    }
}

