/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.animation;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeAccelerationStep;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;
import org.jvnet.lafwidget.animation.GlobalFadeTrackerCallback;
import org.jvnet.lafwidget.animation.RunOnUIThread;
import org.jvnet.lafwidget.utils.LafConstants;
import org.jvnet.lafwidget.utils.TrackableThread;

public class FadeTracker {
    public static final int END_VALUE = 1;
    public static boolean DEBUG_MODE = false;
    private static FadeTracker instance;
    private Map<FadeKind, Map<ComponentId, FadeState>> trackedComponents;
    private Map<Long, FadeKind> fadeInstances;
    private long currLoopId = 0L;
    private List<GlobalFadeTrackerCallback> globalCallbackList;
    private boolean nothingTracked;
    private FadeTrackerThread trackerThread = this.getThread();

    private FadeTracker() {
        this.trackedComponents = new HashMap<FadeKind, Map<ComponentId, FadeState>>();
        this.fadeInstances = new HashMap<Long, FadeKind>();
        this.globalCallbackList = new ArrayList<GlobalFadeTrackerCallback>();
    }

    public static synchronized FadeTracker getInstance() {
        if (instance == null) {
            instance = new FadeTracker();
        }
        return instance;
    }

    private synchronized void updateComponents() {
        if (this.trackedComponents.size() == 0) {
            return;
        }
        HashSet<Container> parents = null;
        for (Map.Entry<FadeKind, Map<ComponentId, FadeState>> entryComp : this.trackedComponents.entrySet()) {
            Map<ComponentId, FadeState> mapComp = entryComp.getValue();
            Iterator<Map.Entry<ComponentId, FadeState>> itKind = mapComp.entrySet().iterator();
            while (itKind.hasNext()) {
                Map.Entry<ComponentId, FadeState> entryKind = itKind.next();
                ComponentId compId = entryKind.getKey();
                FadeState state = entryKind.getValue();
                boolean hasEnded = false;
                if (DEBUG_MODE) {
                    System.out.println("Processing " + state.id + "[" + compId.component.getClass().getSimpleName() + "] from " + state.getFadePosition() + ". Callback - " + (state.getCallback() == null ? "no" : "yes") + ". Displayable " + (compId.component.isDisplayable() ? "yes" : "no"));
                }
                if (state.isFadingIn()) {
                    state.setFadePosition(state.getFadePosition() + state.fadeStep.getNextStep(state.fadeKind, state.getFadePosition(), state.isFadingIn(), state.isLooping()));
                    if (DEBUG_MODE) {
                        System.out.println("New cycle position is " + state.getFadePosition());
                    }
                    if (state.getFadePosition() > 1.0f) {
                        state.setFadePosition(1.0f);
                        if (state.isLooping()) {
                            if (state.isLoopingReverse()) {
                                state.setFadingIn(false);
                            } else if (state.isToStopAtCycleBreak()) {
                                this.fadeInstances.remove(new Long(state.id));
                                hasEnded = true;
                                if (state.getCallback() != null) {
                                    this.callbackCallFadeEnded(state.getCallback(), state.fadeKind);
                                }
                                this.globalCallbackCallFadeEnded(compId.component, compId.subID, state.fadeKind);
                                itKind.remove();
                            } else {
                                state.setFadePosition(0.0f);
                            }
                        } else {
                            this.fadeInstances.remove(new Long(state.id));
                            hasEnded = true;
                            itKind.remove();
                        }
                    }
                } else {
                    state.setFadePosition(state.getFadePosition() - state.fadeStep.getNextStep(state.fadeKind, state.getFadePosition(), state.isFadingIn(), state.isLooping()));
                    if (DEBUG_MODE) {
                        System.out.println("New cycle position is " + state.getFadePosition());
                    }
                    if (state.getFadePosition() < 0.0f) {
                        state.setFadePosition(0.0f);
                        if (state.isLooping()) {
                            boolean stopLoopingAnimation = state.isToStopAtCycleBreak();
                            int loopsToLive = state.getLoopCount();
                            if (loopsToLive > 0) {
                                stopLoopingAnimation = stopLoopingAnimation || --loopsToLive == 0;
                                state.setLoopCount(loopsToLive);
                            }
                            if (stopLoopingAnimation) {
                                this.fadeInstances.remove(new Long(state.id));
                                hasEnded = true;
                                itKind.remove();
                            } else {
                                state.setFadingIn(true);
                            }
                        } else {
                            this.fadeInstances.remove(new Long(state.id));
                            hasEnded = true;
                            itKind.remove();
                        }
                    }
                }
                if (!compId.component.isDisplayable()) continue;
                if (state.getCallback() != null) {
                    if (hasEnded) {
                        if (DEBUG_MODE) {
                            System.out.println("Ending " + state.id + " on " + state.fadeKind.toString());
                        }
                        this.callbackCallFadeEnded(state.getCallback(), state.fadeKind);
                    } else {
                        if (DEBUG_MODE) {
                            System.out.println("Calling " + state.id + " on " + state.fadeKind.toString() + " at " + state.getFadePosition());
                        }
                        this.callbackCallFadePerformed(state.getCallback(), state.fadeKind, state.getFadePosition());
                    }
                }
                if (hasEnded) {
                    this.globalCallbackCallFadeEnded(compId.component, compId.subID, state.fadeKind);
                } else {
                    this.globalCallbackCallFadePerformed(compId.component, compId.subID, state.fadeKind, state.getFadePosition());
                }
                if (state.getCallback() != null) continue;
                if (state.isToRepaintParent()) {
                    if (parents == null) {
                        parents = new HashSet<Container>();
                    }
                    parents.add(compId.component.getParent());
                    continue;
                }
                compId.component.repaint();
            }
        }
        if (parents != null && parents.size() > 0) {
            for (Container parent : parents) {
                parent.repaint();
            }
        }
        this.nothingTracked = this.fadeInstances.size() == 0;
    }

    private void callbackCallFadeEnded(final FadeTrackerCallback fadeCallback, final FadeKind fadeKind) {
        boolean shouldRunOnEDT = false;
        for (Class<?> clazz = fadeCallback.getClass(); clazz != null && !shouldRunOnEDT; clazz = clazz.getSuperclass()) {
            shouldRunOnEDT = clazz.isAnnotationPresent(RunOnUIThread.class);
        }
        if (shouldRunOnEDT) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    fadeCallback.fadeEnded(fadeKind);
                }
            });
        } else {
            fadeCallback.fadeEnded(fadeKind);
        }
    }

    private void callbackCallFadeReversed(final FadeTrackerCallback fadeCallback, final FadeKind fadeKind, final boolean isFadingIn, final float fadeCycle10) {
        boolean shouldRunOnEDT = false;
        for (Class<?> clazz = fadeCallback.getClass(); clazz != null && !shouldRunOnEDT; clazz = clazz.getSuperclass()) {
            shouldRunOnEDT = clazz.isAnnotationPresent(RunOnUIThread.class);
        }
        if (shouldRunOnEDT) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    fadeCallback.fadeReversed(fadeKind, isFadingIn, fadeCycle10);
                }
            });
        } else {
            fadeCallback.fadeReversed(fadeKind, isFadingIn, fadeCycle10);
        }
    }

    private void callbackCallFadePerformed(final FadeTrackerCallback fadeCallback, final FadeKind fadeKind, final float fadePosition) {
        boolean shouldRunOnEDT = false;
        for (Class<?> clazz = fadeCallback.getClass(); clazz != null && !shouldRunOnEDT; clazz = clazz.getSuperclass()) {
            shouldRunOnEDT = clazz.isAnnotationPresent(RunOnUIThread.class);
        }
        if (shouldRunOnEDT) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    fadeCallback.fadePerformed(fadeKind, fadePosition);
                }
            });
        } else {
            fadeCallback.fadePerformed(fadeKind, fadePosition);
        }
    }

    private void globalCallbackCallFadeEnded(Component comp, Comparable subID, FadeKind fadeKind) {
        if (this.globalCallbackList.size() == 0) {
            return;
        }
        if (!fadeKind.isCore) {
            return;
        }
        for (GlobalFadeTrackerCallback globalCallback : this.globalCallbackList) {
            globalCallback.fadeEnded(comp, subID, fadeKind);
        }
    }

    private void globalCallbackCallFadeStarted(Component comp, Comparable subID, FadeKind fadeKind, float initialFadeCycle10) {
        if (this.globalCallbackList.size() == 0) {
            return;
        }
        if (!fadeKind.isCore) {
            return;
        }
        for (GlobalFadeTrackerCallback globalCallback : this.globalCallbackList) {
            globalCallback.fadeStarted(comp, subID, fadeKind, initialFadeCycle10);
        }
    }

    private void globalCallbackCallFadeReversed(Component comp, Comparable subID, FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
        if (this.globalCallbackList.size() == 0) {
            return;
        }
        if (!fadeKind.isCore) {
            return;
        }
        for (GlobalFadeTrackerCallback globalCallback : this.globalCallbackList) {
            globalCallback.fadeReversed(comp, subID, fadeKind, isFadingIn, fadeCycle10);
        }
    }

    private void globalCallbackCallFadePerformed(Component comp, Comparable subID, FadeKind fadeKind, float fadePosition) {
        if (this.globalCallbackList.size() == 0) {
            return;
        }
        if (!fadeKind.isCore) {
            return;
        }
        for (GlobalFadeTrackerCallback globalCallback : this.globalCallbackList) {
            globalCallback.fadePerformed(comp, subID, fadeKind, fadePosition);
        }
    }

    private synchronized FadeState getState(FadeKind fadeKind, Component comp, Comparable<?> componentId) {
        ComponentId cid = new ComponentId(comp, componentId);
        Map<ComponentId, FadeState> map = this.trackedComponents.get(fadeKind);
        if (map == null) {
            map = new HashMap<ComponentId, FadeState>();
            this.trackedComponents.put(fadeKind, map);
        }
        return map.get(cid);
    }

    private synchronized void addState(Component comp, Comparable<?> componentId, FadeKind fadeKind, FadeState fadeState) {
        ComponentId cid = new ComponentId(comp, componentId);
        Map<ComponentId, FadeState> map = this.trackedComponents.get(fadeKind);
        if (map == null) {
            map = new HashMap<ComponentId, FadeState>();
            this.trackedComponents.put(fadeKind, map);
        }
        map.put(cid, fadeState);
        this.fadeInstances.put(fadeState.id, fadeKind);
        this.nothingTracked = false;
        if (DEBUG_MODE) {
            System.out.println("Added (" + fadeState.id + ") on " + comp.getClass().getSimpleName() + "[" + componentId + "]. Fade " + fadeKind.toString() + " and fading " + (fadeState.isFadingIn() ? "in" : "out") + ". Callback - " + (fadeState.getCallback() == null ? "no" : "yes"));
        }
    }

    public synchronized long trackFadeIn(FadeKind fadeKind, Component comp, boolean toRepaintParent, FadeTrackerCallback callback) {
        return this.trackFadeIn(fadeKind, comp, null, toRepaintParent, callback);
    }

    public synchronized long trackFadeIn(FadeKind fadeKind, Component comp, int componentId, boolean toRepaintParent, FadeTrackerCallback callback) {
        return this.trackFadeIn(fadeKind, comp, new Integer(componentId), toRepaintParent, callback);
    }

    public synchronized long trackFadeIn(FadeKind fadeKind, Component comp, Comparable<?> componentId, boolean toRepaintParent, FadeTrackerCallback callback) {
        return this.trackFadeIn(fadeKind, comp, componentId, toRepaintParent, callback, LafWidgetUtilities.getAnimationKind(comp));
    }

    public synchronized long trackFadeIn(FadeKind fadeKind, Component comp, Comparable<?> componentId, boolean toRepaintParent, FadeTrackerCallback callback, LafConstants.AnimationKind aKind) {
        if (fadeKind == null) {
            throw new IllegalArgumentException("Can't pass null fadeKind");
        }
        if (comp == null || !comp.isDisplayable()) {
            if (callback != null) {
                this.callbackCallFadeEnded(callback, fadeKind);
            }
            this.globalCallbackCallFadeEnded(comp, componentId, fadeKind);
            return -1L;
        }
        if (LafWidgetUtilities.hasNoFades(comp, fadeKind)) {
            if (callback != null) {
                this.callbackCallFadeEnded(callback, fadeKind);
            } else if (toRepaintParent && comp.getParent() != null) {
                comp.getParent().repaint();
            } else {
                comp.repaint();
            }
            this.globalCallbackCallFadeEnded(comp, componentId, fadeKind);
            return -1L;
        }
        this.getThread();
        FadeState fadeState = this.getState(fadeKind, comp, componentId);
        if (fadeState == null) {
            fadeState = new FadeState(fadeKind, 0.0f, true, toRepaintParent);
            fadeState.fadeStep = aKind.getStep();
            if (fadeKind == FadeKind.SELECTION) {
                fadeState.fadeStep = new FadeAccelerationStep(fadeState.fadeStep, 2.0f);
            }
            fadeState.setCallback(callback);
            this.addState(comp, componentId, fadeKind, fadeState);
            this.globalCallbackCallFadeStarted(comp, componentId, fadeKind, fadeState.getFadePosition());
        } else {
            if (!fadeState.isFadingIn()) {
                if (fadeState.getCallback() != null) {
                    this.callbackCallFadeReversed(fadeState.getCallback(), fadeKind, true, fadeState.getFadePosition());
                }
                this.globalCallbackCallFadeReversed(comp, componentId, fadeKind, true, fadeState.getFadePosition());
            }
            fadeState.setFadingIn(true);
            fadeState.setCallback(callback);
        }
        return fadeState.id;
    }

    public synchronized long trackFadeOut(FadeKind fadeKind, Component comp, boolean toRepaintParent, FadeTrackerCallback callback) {
        return this.trackFadeOut(fadeKind, comp, null, toRepaintParent, callback);
    }

    public synchronized long trackFadeOut(FadeKind fadeKind, Component comp, int componentId, boolean toRepaintParent, FadeTrackerCallback callback) {
        return this.trackFadeOut(fadeKind, comp, new Integer(componentId), toRepaintParent, callback);
    }

    public synchronized long trackFadeOut(FadeKind fadeKind, Component comp, Comparable<?> componentId, boolean toRepaintParent, FadeTrackerCallback callback) {
        return this.trackFadeOut(fadeKind, comp, componentId, toRepaintParent, callback, LafWidgetUtilities.getAnimationKind(comp));
    }

    public synchronized long trackFadeOut(FadeKind fadeKind, Component comp, Comparable<?> componentId, boolean toRepaintParent, FadeTrackerCallback callback, LafConstants.AnimationKind aKind) {
        if (fadeKind == null) {
            throw new IllegalArgumentException("Can't pass null fadeKind");
        }
        if (comp == null || !comp.isDisplayable()) {
            if (callback != null) {
                this.callbackCallFadeEnded(callback, fadeKind);
            }
            this.globalCallbackCallFadeEnded(comp, componentId, fadeKind);
            return -1L;
        }
        if (LafWidgetUtilities.hasNoFades(comp, fadeKind)) {
            if (callback != null) {
                this.callbackCallFadeEnded(callback, fadeKind);
            } else if (toRepaintParent && comp.getParent() != null) {
                comp.getParent().repaint();
            } else {
                comp.repaint();
            }
            this.globalCallbackCallFadeEnded(comp, componentId, fadeKind);
            return -1L;
        }
        this.getThread();
        FadeState fadeState = this.getState(fadeKind, comp, componentId);
        if (fadeState == null) {
            fadeState = new FadeState(fadeKind, 1.0f, false, toRepaintParent);
            fadeState.fadeStep = aKind.getStep();
            if (fadeKind == FadeKind.SELECTION) {
                fadeState.fadeStep = new FadeAccelerationStep(fadeState.fadeStep, 2.0f);
            }
            fadeState.setCallback(callback);
            this.addState(comp, componentId, fadeKind, fadeState);
            this.globalCallbackCallFadeStarted(comp, componentId, fadeKind, fadeState.getFadePosition());
        } else {
            if (fadeState.isFadingIn()) {
                if (fadeState.getCallback() != null) {
                    this.callbackCallFadeReversed(fadeState.getCallback(), fadeKind, false, fadeState.getFadePosition());
                }
                this.globalCallbackCallFadeReversed(comp, componentId, fadeKind, false, fadeState.getFadePosition());
            }
            fadeState.setFadingIn(false);
            fadeState.setCallback(callback);
        }
        return fadeState.id;
    }

    public synchronized long trackFade(Component comp, FadeKind fadeKind, boolean isFadeIn, boolean toRepaintParent) {
        return this.trackFade(comp, fadeKind, isFadeIn, toRepaintParent, null);
    }

    public synchronized long trackFade(Component comp, FadeKind fadeKind, boolean isFadeIn, boolean toRepaintParent, FadeTrackerCallback callback) {
        if (isFadeIn) {
            return this.trackFadeIn(fadeKind, comp, toRepaintParent, callback);
        }
        return this.trackFadeOut(fadeKind, comp, toRepaintParent, callback);
    }

    public synchronized long trackFadeLooping(FadeKind fadeKind, LafConstants.AnimationKind animationKind, Component comp, Comparable<?> componentId, boolean toRepaintParent, FadeTrackerCallback callback, int loopCount, boolean isLoopingReverse) {
        if (fadeKind == null) {
            throw new IllegalArgumentException("Can't pass null fadeKind");
        }
        this.getThread();
        if (LafWidgetUtilities.hasNoFades(comp, fadeKind)) {
            if (callback != null) {
                this.callbackCallFadeEnded(callback, fadeKind);
            } else if (comp != null) {
                if (toRepaintParent && comp.getParent() != null) {
                    comp.getParent().repaint();
                } else {
                    comp.repaint();
                }
            }
            this.globalCallbackCallFadeEnded(comp, componentId, fadeKind);
            return -1L;
        }
        FadeState fadeState = this.getState(fadeKind, comp, componentId);
        if (fadeState == null) {
            fadeState = new FadeState(fadeKind, 0.0f, true, toRepaintParent);
            fadeState.fadeStep = animationKind.getStep();
            fadeState.setLooping(true);
            fadeState.setLoopingReverse(isLoopingReverse);
            fadeState.setCallback(callback);
            fadeState.setLoopCount(loopCount);
            this.addState(comp, componentId, fadeKind, fadeState);
            this.globalCallbackCallFadeStarted(comp, componentId, fadeKind, fadeState.getFadePosition());
        } else {
            fadeState.setLooping(true);
            fadeState.setLoopingReverse(isLoopingReverse);
            fadeState.setCallback(callback);
            fadeState.setToStopAtCycleBreak(false);
            fadeState.setLoopCount(loopCount);
        }
        return fadeState.id;
    }

    public boolean isTracked(Component comp, FadeKind fadeKind) {
        return this.isTracked(comp, null, fadeKind);
    }

    public boolean isTracked(Component comp, int componentId, FadeKind fadeKind) {
        return this.isTracked(comp, new Integer(componentId), fadeKind);
    }

    public boolean isTracked(Component comp, Comparable<?> componentId, FadeKind fadeKind) {
        if (this.nothingTracked) {
            return false;
        }
        Map<ComponentId, FadeState> map = this.trackedComponents.get(fadeKind);
        if (map == null) {
            return false;
        }
        ComponentId cid = new ComponentId(comp, componentId);
        return map.containsKey(cid);
    }

    public boolean isTracked(Component comp, Comparable<?> componentId, FadeKind fadeKind, boolean checkFadeIn) {
        if (fadeKind == null) {
            throw new IllegalArgumentException("Can't pass null fadeKind");
        }
        if (this.nothingTracked) {
            return false;
        }
        Map<ComponentId, FadeState> map = this.trackedComponents.get(fadeKind);
        if (map == null) {
            return false;
        }
        ComponentId cid = new ComponentId(comp, componentId);
        FadeState fState = map.get(cid);
        if (fState == null) {
            return false;
        }
        return fState.isFadingIn() == checkFadeIn;
    }

    public synchronized float getFade(Component comp, FadeKind fadeKind) {
        return this.getFade(comp, null, fadeKind);
    }

    public synchronized float getFade(Component comp, int componentId, FadeKind fadeKind) {
        return this.getFade(comp, new Integer(componentId), fadeKind);
    }

    public synchronized float getFade(Component comp, Comparable<?> componentId, FadeKind fadeKind) {
        if (fadeKind == null) {
            throw new IllegalArgumentException("Can't pass null fadeKind");
        }
        if (this.nothingTracked) {
            return 0.0f;
        }
        Map<ComponentId, FadeState> map = this.trackedComponents.get(fadeKind);
        if (map == null || map.size() == 0) {
            return 0.0f;
        }
        ComponentId cid = new ComponentId(comp, componentId);
        FadeState state = map.get(cid);
        if (state == null) {
            return 0.0f;
        }
        return state.getFadePosition();
    }

    public FadeState getFadeState(Component comp, FadeKind fadeKind) {
        return this.getFadeState(comp, null, fadeKind);
    }

    public FadeState getFadeState(Component comp, int componentId, FadeKind fadeKind) {
        return this.getFadeState(comp, new Integer(componentId), fadeKind);
    }

    public synchronized FadeState getFadeState(Component comp, Comparable<?> componentId, FadeKind fadeKind) {
        if (fadeKind == null) {
            throw new IllegalArgumentException("Can't pass null fadeKind");
        }
        if (this.nothingTracked) {
            return null;
        }
        Map<ComponentId, FadeState> map = this.trackedComponents.get(fadeKind);
        if (map == null || map.size() == 0) {
            return null;
        }
        ComponentId cid = new ComponentId(comp, componentId);
        FadeState state = map.get(cid);
        if (state == null) {
            return null;
        }
        return state.getCopy();
    }

    public synchronized void stopAllTimers() {
        for (Map.Entry<FadeKind, Map<ComponentId, FadeState>> entryComp : this.trackedComponents.entrySet()) {
            Map<ComponentId, FadeState> mapComp = entryComp.getValue();
            for (Map.Entry<ComponentId, FadeState> entryKind : mapComp.entrySet()) {
                ComponentId compId = entryKind.getKey();
                FadeState state = entryKind.getValue();
                if (state.getCallback() != null) {
                    this.callbackCallFadeEnded(state.getCallback(), state.fadeKind);
                }
                this.globalCallbackCallFadeEnded(compId.component, compId.subID, state.fadeKind);
            }
        }
        this.trackedComponents.clear();
        this.fadeInstances.clear();
    }

    private synchronized FadeTrackerThread getThread() {
        if (this.trackerThread == null) {
            this.trackerThread = new FadeTrackerThread();
            this.trackerThread.start();
        }
        return this.trackerThread;
    }

    public synchronized void cancelFadeInstance(long fadeInstanceId) {
        FadeKind fadeKind = this.fadeInstances.get(new Long(fadeInstanceId));
        if (fadeKind != null) {
            Map<ComponentId, FadeState> compFades = this.trackedComponents.get(fadeKind);
            if (compFades != null) {
                Iterator<Map.Entry<ComponentId, FadeState>> itKind = compFades.entrySet().iterator();
                while (itKind.hasNext()) {
                    Map.Entry<ComponentId, FadeState> entryKind = itKind.next();
                    ComponentId compId = entryKind.getKey();
                    FadeState state = entryKind.getValue();
                    if (fadeInstanceId != state.id) continue;
                    itKind.remove();
                    if (state.getCallback() != null) {
                        this.callbackCallFadeEnded(state.getCallback(), state.fadeKind);
                    } else if (state.isToRepaintParent()) {
                        entryKind.getKey().component.getParent().repaint();
                    } else {
                        entryKind.getKey().component.repaint();
                    }
                    this.globalCallbackCallFadeEnded(compId.component, compId.subID, state.fadeKind);
                }
            }
            this.fadeInstances.remove(new Long(fadeInstanceId));
        }
    }

    public synchronized void requestStopOnCycleBreak(long fadeInstanceId) {
        FadeKind fadeKind = this.fadeInstances.get(fadeInstanceId);
        if (fadeKind != null) {
            Map<ComponentId, FadeState> compFades = this.trackedComponents.get(fadeKind);
            for (FadeState fadeState : compFades.values()) {
                if (fadeInstanceId != fadeState.id) continue;
                fadeState.toStopAtCycleBreak();
            }
        }
    }

    public synchronized Set<Component> getAllComponentsByFadeKind(FadeKind fadeKind) {
        HashSet<Component> result = new HashSet<Component>();
        Map<ComponentId, FadeState> comps = this.trackedComponents.get(fadeKind);
        if (comps != null) {
            for (ComponentId cid : comps.keySet()) {
                result.add(cid.component);
            }
        }
        return result;
    }

    public long getCurrLoopId() {
        return this.currLoopId;
    }

    public void addGlobalCallback(GlobalFadeTrackerCallback callback) {
        this.globalCallbackList.add(callback);
    }

    public void removeGlobalCallback(GlobalFadeTrackerCallback callback) {
        this.globalCallbackList.remove(callback);
    }

    private class FadeTrackerThread
    extends TrackableThread {
        public static final int DELAY = 40;
        private boolean stopRequested;

        public FadeTrackerThread() {
            this.setName("Laf-Widget fade tracker");
            this.stopRequested = false;
        }

        @Override
        public void run() {
            while (!this.stopRequested) {
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                FadeTracker.this.updateComponents();
                FadeTracker.this.currLoopId++;
            }
        }

        @Override
        protected void requestStop() {
            this.stopRequested = true;
            FadeTracker.this.trackerThread = null;
        }
    }

    protected static class ComponentId {
        public Component component;
        public Comparable subID;

        public ComponentId(Component component, Comparable subID) {
            this.component = component;
            this.subID = subID;
        }

        public int hashCode() {
            int result = this.component.hashCode();
            if (this.subID != null) {
                result &= this.subID.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ComponentId) {
                ComponentId cid = (ComponentId)obj;
                try {
                    boolean result;
                    boolean bl = result = this.component == cid.component;
                    result = this.subID == null ? result && cid.subID == null : result && this.subID.compareTo(cid.subID) == 0;
                    return result;
                }
                catch (Exception exc) {
                    return false;
                }
            }
            return false;
        }
    }
}

