/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ear;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.plugins.ear.descriptor.DeploymentDescriptor;
import org.gradle.plugins.ear.descriptor.internal.DefaultDeploymentDescriptor;
import org.gradle.plugins.ear.descriptor.internal.DefaultEarModule;
import org.gradle.plugins.ear.descriptor.internal.DefaultEarWebModule;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.GUtil;
import org.gradle.work.DisableCachingByDefault;
import org.jspecify.annotations.Nullable;

@DisableCachingByDefault(because="Not worth caching")
public abstract class Ear
extends Jar {
    public static final String EAR_EXTENSION = "ear";
    private String libDirName;
    private final Property<Boolean> generateDeploymentDescriptor;
    private DeploymentDescriptor deploymentDescriptor;
    private CopySpec lib;
    private final DirectoryProperty appDir;

    public Ear() {
        this.getArchiveExtension().set((Object)EAR_EXTENSION);
        this.setMetadataCharset("UTF-8");
        this.generateDeploymentDescriptor = this.getObjectFactory().property(Boolean.class);
        this.generateDeploymentDescriptor.convention((Object)true);
        this.lib = this.getRootSpec().addChildBeforeSpec(this.getMainSpec()).into((Object)SerializableLambdas.callable((SerializableLambdas.SerializableCallable & Serializable)() -> (String)GUtil.elvis((Object)this.getLibDirName(), (Object)"lib")));
        this.getMainSpec().appendCachingSafeCopyAction(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)details -> {
            if (((Boolean)this.generateDeploymentDescriptor.get()).booleanValue()) {
                this.checkIfShouldGenerateDeploymentDescriptor((FileCopyDetails)details);
                this.recordTopLevelModules((FileCopyDetails)details);
            }
        }));
        CopySpecInternal metaInf = (CopySpecInternal)this.getMainSpec().addChild().into((Object)"META-INF");
        CopySpecInternal descriptorChild = metaInf.addChild();
        descriptorChild.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        descriptorChild.from(new Object[]{SerializableLambdas.callable((SerializableLambdas.SerializableCallable & Serializable)() -> {
            DeploymentDescriptor descriptor = this.getDeploymentDescriptor();
            if (descriptor != null && ((Boolean)this.generateDeploymentDescriptor.get()).booleanValue()) {
                String descriptorFileName;
                if (descriptor.getLibraryDirectory() == null) {
                    descriptor.setLibraryDirectory(this.getLibDirName());
                }
                if ((descriptorFileName = descriptor.getFileName()).contains("/") || descriptorFileName.contains(File.separator)) {
                    throw new InvalidUserDataException("Deployment descriptor file name must be a simple name but was " + descriptorFileName);
                }
                OutputChangeListener outputChangeListener = this.outputChangeListener();
                return this.fileCollectionFactory().generated(this.getTemporaryDirFactory(), descriptorFileName, SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)file -> outputChangeListener.invalidateCachesFor(Collections.singleton(file.getAbsolutePath()))), SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)outputStream -> descriptor.writeTo(new OutputStreamWriter((OutputStream)outputStream))));
            }
            return null;
        })});
        this.appDir = this.getObjectFactory().directoryProperty();
    }

    private FileCollectionFactory fileCollectionFactory() {
        return (FileCollectionFactory)this.getServices().get(FileCollectionFactory.class);
    }

    private OutputChangeListener outputChangeListener() {
        return (OutputChangeListener)this.getServices().get(OutputChangeListener.class);
    }

    private void recordTopLevelModules(FileCopyDetails details) {
        DeploymentDescriptor deploymentDescriptor = this.getDeploymentDescriptor();
        if (deploymentDescriptor != null && details.getPath().lastIndexOf("/") <= 0) {
            DefaultEarModule module = details.getPath().toLowerCase(Locale.ROOT).endsWith(".war") ? new DefaultEarWebModule(details.getPath(), details.getPath().substring(0, details.getPath().lastIndexOf("."))) : new DefaultEarModule(details.getPath());
            deploymentDescriptor.getModules().add(module);
        }
    }

    private void checkIfShouldGenerateDeploymentDescriptor(FileCopyDetails details) {
        String descriptorPath;
        DeploymentDescriptor deploymentDescriptor = this.getDeploymentDescriptor();
        String string = descriptorPath = deploymentDescriptor != null ? "META-INF/" + deploymentDescriptor.getFileName() : null;
        if (details.getPath().equalsIgnoreCase(descriptorPath)) {
            this.setDeploymentDescriptor(null);
            details.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        }
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    public Ear deploymentDescriptor(@DelegatesTo(value=DeploymentDescriptor.class, strategy=1) Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.forceDeploymentDescriptor());
        return this;
    }

    public Ear deploymentDescriptor(Action<? super DeploymentDescriptor> configureAction) {
        configureAction.execute((Object)this.forceDeploymentDescriptor());
        return this;
    }

    private DeploymentDescriptor forceDeploymentDescriptor() {
        if (this.deploymentDescriptor == null) {
            this.deploymentDescriptor = (DeploymentDescriptor)this.getObjectFactory().newInstance(DefaultDeploymentDescriptor.class, new Object[0]);
        }
        return this.deploymentDescriptor;
    }

    @Internal
    @ToBeReplacedByLazyProperty(comment="Should this be lazy?")
    public CopySpec getLib() {
        return ((CopySpecInternal)this.lib).addChild();
    }

    public CopySpec lib(@DelegatesTo(value=CopySpec.class, strategy=1) Closure configureClosure) {
        return (CopySpec)ConfigureUtil.configure((Closure)configureClosure, (Object)this.getLib());
    }

    public CopySpec lib(Action<? super CopySpec> configureAction) {
        CopySpec copySpec = this.getLib();
        configureAction.execute((Object)copySpec);
        return copySpec;
    }

    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public @Nullable String getLibDirName() {
        return this.libDirName;
    }

    public void setLibDirName(@Nullable String libDirName) {
        this.libDirName = libDirName;
    }

    @Input
    public Property<Boolean> getGenerateDeploymentDescriptor() {
        return this.generateDeploymentDescriptor;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public DeploymentDescriptor getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptor(DeploymentDescriptor deploymentDescriptor) {
        this.deploymentDescriptor = deploymentDescriptor;
    }

    @Internal
    public DirectoryProperty getAppDirectory() {
        return this.appDir;
    }
}

