/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve;

import com.google.common.base.Throwables;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import org.gradle.internal.resource.transport.http.HttpErrorStatusCodeException;

public class ResolveExceptionAnalyzer {
    public static boolean isCriticalFailure(Throwable throwable) {
        Throwable rootCause = Throwables.getRootCause((Throwable)throwable);
        return ResolveExceptionAnalyzer.isTimeoutException(rootCause) || ResolveExceptionAnalyzer.isUnrecoverable5xxStatusCode(rootCause) || ResolveExceptionAnalyzer.isUnknownHostException(rootCause);
    }

    private static boolean isUnknownHostException(Throwable rootCause) {
        return rootCause instanceof UnknownHostException;
    }

    private static boolean isTimeoutException(Throwable rootCause) {
        return rootCause instanceof InterruptedIOException;
    }

    private static boolean isUnrecoverable5xxStatusCode(Throwable rootCause) {
        return rootCause instanceof HttpErrorStatusCodeException && ((HttpErrorStatusCodeException)rootCause).isServerError();
    }
}

